/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.admin.rest.internal.resource.v1_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.saml.admin.rest.dto.v1_0.Idp;
import com.liferay.saml.admin.rest.dto.v1_0.SamlProvider;
import com.liferay.saml.admin.rest.dto.v1_0.Sp;
import com.liferay.saml.admin.rest.internal.resource.v1_0.BaseSamlProviderResourceImpl;
import com.liferay.saml.admin.rest.resource.v1_0.SamlProviderResource;
import com.liferay.saml.runtime.configuration.SamlConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.exception.CredentialException;
import com.liferay.saml.runtime.exception.EntityIdException;
import com.liferay.saml.runtime.metadata.LocalEntityManager;
import java.io.Serializable;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.function.Supplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlConfiguration"}, properties={"OSGI-INF/liferay/rest/v1_0/saml-provider.properties"}, scope=ServiceScope.PROTOTYPE, service={SamlProviderResource.class})
public class SamlProviderResourceImpl
extends BaseSamlProviderResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(SamlProviderResourceImpl.class);
    private SamlProviderConfiguration _defaultCompanySamlProviderConfiguration = (SamlProviderConfiguration)ConfigurableUtil.createConfigurable(SamlProviderConfiguration.class, Collections.emptyMap());
    private String _defaultCompanySamlProviderConfigurationPid;
    @Reference
    private LocalEntityManager _localEntityManager;
    private SamlConfiguration _samlConfiguration;
    @Reference
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;
    private ServiceRegistration<?> _serviceRegistration;

    @Override
    public SamlProvider getSamlProvider() throws Exception {
        this._checkPermission();
        final SamlProviderConfiguration samlProviderConfiguration = this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
        SamlProvider samlProvider = new SamlProvider(){
            {
                this.setEnabled(() -> ((SamlProviderConfiguration)samlProviderConfiguration).enabled());
                this.setEntityId(() -> ((SamlProviderConfiguration)samlProviderConfiguration).entityId());
                this.setSignMetadata(() -> ((SamlProviderConfiguration)samlProviderConfiguration).signMetadata());
                this.setSslRequired(() -> ((SamlProviderConfiguration)samlProviderConfiguration).sslRequired());
            }
        };
        String role = samlProviderConfiguration.role();
        if ("sp".equals(role)) {
            samlProvider.setRole(() -> SamlProvider.Role.SP);
            samlProvider.setSp(() -> this._getSp(samlProviderConfiguration));
        } else if ("idp".equals(role)) {
            samlProvider.setIdp(() -> this._getIdp(samlProviderConfiguration));
            samlProvider.setRole(() -> SamlProvider.Role.IDP);
        }
        return samlProvider;
    }

    @Override
    public SamlProvider patchSamlProvider(SamlProvider samlProvider) throws Exception {
        this._checkPermission();
        return this._updateSamlProvider(samlProvider, this._samlProviderConfigurationHelper.getSamlProviderConfiguration());
    }

    @Override
    public SamlProvider postSamlProvider(SamlProvider samlProvider) throws Exception {
        this._checkPermission();
        return this._updateSamlProvider(samlProvider, this._defaultCompanySamlProviderConfiguration);
    }

    @Override
    public Page<SamlProvider> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        this._checkPermission();
        return Page.of(Collections.singleton(this.getSamlProvider()));
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._samlConfiguration = (SamlConfiguration)ConfigurableUtil.createConfigurable(SamlConfiguration.class, properties);
        this._serviceRegistration = bundleContext.registerService(ManagedServiceFactory.class, (Object)new DefaultCompanyManagedServiceFactory(), (Dictionary)HashMapDictionaryBuilder.put((Object)"service.pid", (Object)"com.liferay.saml.runtime.configuration.SamlProviderConfiguration").build());
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private void _authenticateLocalEntityCertificate(String certificateKeyPassword, LocalEntityManager.CertificateUsage certificateUsage, String entityId) throws Exception {
        try {
            this._localEntityManager.authenticateLocalEntityCertificate(certificateKeyPassword, certificateUsage, entityId);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw new CredentialException(StringBundler.concat((String[])new String[]{"Unable to authenticate with the ", certificateUsage.name(), " certificate. Verify that the SAML KeyStore contains a ", "certificate for the entity ID and that it is protected ", "by the provided key credential password."}));
        }
    }

    private void _checkPermission() throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(CompanyThreadLocal.getCompanyId().longValue())) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker.getUserId());
        }
    }

    private Idp _getIdp(final SamlProviderConfiguration samlProviderConfiguration) throws Exception {
        return new Idp(){
            {
                this.setAuthnRequestSignatureRequired(() -> ((SamlProviderConfiguration)samlProviderConfiguration).authnRequestSignatureRequired());
                this.setDefaultAssertionLifetime(() -> ((SamlProviderConfiguration)samlProviderConfiguration).defaultAssertionLifetime());
                this.setSessionMaximumAge(() -> ((SamlProviderConfiguration)samlProviderConfiguration).sessionMaximumAge());
                this.setSessionTimeout(() -> ((SamlProviderConfiguration)samlProviderConfiguration).sessionTimeout());
            }
        };
    }

    private Sp _getSp(final SamlProviderConfiguration samlProviderConfiguration) throws Exception {
        return new Sp(){
            {
                this.setAllowShowingTheLoginPortlet(() -> ((SamlProviderConfiguration)samlProviderConfiguration).allowShowingTheLoginPortlet());
                this.setAssertionSignatureRequired(() -> ((SamlProviderConfiguration)samlProviderConfiguration).assertionSignatureRequired());
                this.setClockSkew(() -> ((SamlProviderConfiguration)samlProviderConfiguration).clockSkew());
                this.setLdapImportEnabled(() -> ((SamlProviderConfiguration)samlProviderConfiguration).ldapImportEnabled());
                this.setSignAuthnRequest(() -> ((SamlProviderConfiguration)samlProviderConfiguration).signAuthnRequest());
            }
        };
    }

    private boolean _isIdpRoleDisabled(boolean enabled, SamlProviderConfiguration samlProviderConfiguration) {
        if (this._samlConfiguration.idpRoleConfigurationEnabled()) {
            return false;
        }
        String role = samlProviderConfiguration.role();
        if (Validator.isNull((String)role) || !role.equals("idp")) {
            return true;
        }
        return !samlProviderConfiguration.enabled() && enabled;
    }

    private boolean _isValidRole(String role) {
        if (Validator.isBlank((String)role)) {
            return false;
        }
        return role.equals("idp") || role.equals("sp");
    }

    private void _setIdpProperties(Idp idp, SamlProviderConfiguration samlProviderConfiguration, UnicodeProperties unicodeProperties) {
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).defaultAssertionLifetime(), "saml.idp.assertion.lifetime", unicodeProperties, this._toNullableString(idp.getDefaultAssertionLifetime()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).authnRequestSignatureRequired(), "saml.idp.authn.request.signature.required", unicodeProperties, this._toNullableString(idp.getAuthnRequestSignatureRequired()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).sessionMaximumAge(), "saml.idp.session.maximum.age", unicodeProperties, this._toNullableString(idp.getSessionMaximumAge()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).sessionTimeout(), "saml.idp.session.timeout", unicodeProperties, this._toNullableString(idp.getSessionTimeout()));
        unicodeProperties.put("saml.role", "idp");
    }

    private void _setProperty(Supplier<Object> defaultSupplier, String key, UnicodeProperties unicodeProperties, String value) {
        if (value == null) {
            unicodeProperties.put(key, this._toNullableString(defaultSupplier.get()));
            return;
        }
        unicodeProperties.put(key, value);
    }

    private void _setSamlProviderProperties(SamlProvider samlProvider, SamlProviderConfiguration samlProviderConfiguration, UnicodeProperties unicodeProperties) {
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).enabled(), "saml.enabled", unicodeProperties, this._toNullableString(samlProvider.getEnabled()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).entityId(), "saml.entity.id", unicodeProperties, samlProvider.getEntityId());
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).keyStoreCredentialPassword(), "saml.keystore.credential.password", unicodeProperties, this._toNullableString(samlProvider.getKeyStoreCredentialPassword()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).signMetadata(), "saml.sign.metadata", unicodeProperties, this._toNullableString(samlProvider.getSignMetadata()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).sslRequired(), "saml.ssl.required", unicodeProperties, this._toNullableString(samlProvider.getSslRequired()));
    }

    private void _setSpProperties(String entityId, SamlProviderConfiguration samlProviderConfiguration, Sp sp, UnicodeProperties unicodeProperties) throws Exception {
        if (sp.getKeyStoreEncryptionCredentialPassword() != null) {
            this._authenticateLocalEntityCertificate(sp.getKeyStoreEncryptionCredentialPassword(), LocalEntityManager.CertificateUsage.ENCRYPTION, entityId);
        }
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).keyStoreCredentialPassword(), "saml.keystore.encryption.credential.password", unicodeProperties, this._toNullableString(sp.getKeyStoreEncryptionCredentialPassword()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).allowShowingTheLoginPortlet(), "saml.sp.allow.showing.the.login.portlet", unicodeProperties, this._toNullableString(sp.getAllowShowingTheLoginPortlet()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).assertionSignatureRequired(), "saml.sp.assertion.signature.required", unicodeProperties, this._toNullableString(sp.getAssertionSignatureRequired()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).clockSkew(), "saml.sp.clock.skew", unicodeProperties, this._toNullableString(sp.getClockSkew()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).ldapImportEnabled(), "saml.sp.ldap.import.enabled", unicodeProperties, this._toNullableString(sp.getLdapImportEnabled()));
        this._setProperty(() -> ((SamlProviderConfiguration)samlProviderConfiguration).signAuthnRequest(), "saml.sp.sign.authn.request", unicodeProperties, this._toNullableString(sp.getSignAuthnRequest()));
        unicodeProperties.put("saml.role", "sp");
    }

    private String _toNullableString(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    private SamlProvider _updateSamlProvider(SamlProvider samlProvider, SamlProviderConfiguration samlProviderConfiguration) throws Exception {
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.create((boolean)false).build();
        this._setSamlProviderProperties(samlProvider, samlProviderConfiguration, unicodeProperties);
        String entityId = samlProvider.getEntityId();
        if (Validator.isNotNull((String)entityId)) {
            if (entityId.length() > 1024) {
                throw new EntityIdException("Entity ID is longer than 1024 characters");
            }
        } else {
            entityId = samlProviderConfiguration.entityId();
        }
        if (GetterUtil.getBoolean((Object)samlProvider.getEnabled()) || !Validator.isBlank((String)samlProvider.getKeyStoreCredentialPassword())) {
            this._authenticateLocalEntityCertificate(GetterUtil.getString((String)samlProvider.getKeyStoreCredentialPassword(), (String)samlProviderConfiguration.keyStoreCredentialPassword()), LocalEntityManager.CertificateUsage.SIGNING, entityId);
        }
        if (samlProvider.getIdp() != null) {
            if (this._isIdpRoleDisabled(samlProvider.getEnabled(), samlProviderConfiguration)) {
                throw new ConfigurationException("The identity provider role is disabled");
            }
            if (samlProvider.getSp() != null) {
                throw new ConfigurationException("Identity and service provider roles are mutually exclusive");
            }
            this._setIdpProperties(samlProvider.getIdp(), samlProviderConfiguration, unicodeProperties);
        } else if (samlProvider.getSp() != null) {
            this._setSpProperties(entityId, samlProviderConfiguration, samlProvider.getSp(), unicodeProperties);
        }
        if (GetterUtil.getBoolean((Object)samlProvider.getEnabled()) && !this._isValidRole(GetterUtil.get((String)((String)unicodeProperties.get((Object)"saml.role")), (String)samlProviderConfiguration.role()))) {
            throw new ConfigurationException("Unable to enable a provider without a role");
        }
        this._samlProviderConfigurationHelper.updateProperties(unicodeProperties);
        return this.getSamlProvider();
    }

    private class DefaultCompanyManagedServiceFactory
    implements ManagedServiceFactory {
        private DefaultCompanyManagedServiceFactory() {
        }

        public void deleted(String pid) {
            if (pid.equals(SamlProviderResourceImpl.this._defaultCompanySamlProviderConfigurationPid)) {
                SamlProviderResourceImpl.this._defaultCompanySamlProviderConfiguration = (SamlProviderConfiguration)ConfigurableUtil.createConfigurable(SamlProviderConfiguration.class, Collections.emptyMap());
                SamlProviderResourceImpl.this._defaultCompanySamlProviderConfigurationPid = null;
            }
        }

        public String getName() {
            return DefaultCompanyManagedServiceFactory.class.getName();
        }

        public void updated(String pid, Dictionary<String, ?> properties) {
            if (GetterUtil.getLong(properties.get("companyId")) == 0L) {
                SamlProviderResourceImpl.this._defaultCompanySamlProviderConfiguration = (SamlProviderConfiguration)ConfigurableUtil.createConfigurable(SamlProviderConfiguration.class, properties);
                SamlProviderResourceImpl.this._defaultCompanySamlProviderConfigurationPid = pid;
            }
        }
    }
}

