/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.rss.web.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.rss.util.RSSUtil;
import com.liferay.rss.web.internal.util.RSSFeed;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.List;
import java.util.Objects;

public class RSSFeedEntry {
    private static final Log _log = LogFactoryUtil.getLog(RSSFeedEntry.class);
    private final RSSFeed _rssFeed;
    private final String _syndEnclosureLink;
    private final String _syndEnclosureLinkTitle;
    private final SyndEntry _syndEntry;
    private final String _syndEntryLink;
    private final ThemeDisplay _themeDisplay;

    public RSSFeedEntry(RSSFeed rssFeed, SyndEntry syndEntry, ThemeDisplay themeDisplay) {
        this._rssFeed = rssFeed;
        this._syndEntry = syndEntry;
        this._themeDisplay = themeDisplay;
        List syndEnclosures = syndEntry.getEnclosures();
        String syndEnclosureLink = "";
        String syndEnclosureLinkTitle = syndEntry.getTitle();
        for (SyndEnclosure syndEnclosure : syndEnclosures) {
            if (!Validator.isNotNull((String)syndEnclosure.getUrl())) continue;
            syndEnclosureLink = syndEnclosure.getUrl();
            int pos = syndEnclosureLink.lastIndexOf("/");
            if (pos > -1) {
                syndEnclosureLinkTitle = syndEnclosureLink.substring(pos + 1);
                break;
            }
            syndEnclosureLinkTitle = syndEnclosureLink;
            break;
        }
        this._syndEnclosureLink = syndEnclosureLink;
        this._syndEnclosureLinkTitle = syndEnclosureLinkTitle;
        String syndEntryLink = syndEntry.getLink();
        if (Validator.isNotNull((String)syndEntryLink) && !HttpUtil.hasDomain((String)syndEntryLink)) {
            syndEntryLink = rssFeed.getBaseURL() + syndEntryLink;
        }
        this._syndEntryLink = syndEntryLink;
    }

    public String getSanitizedContent() {
        String baseURL = this._rssFeed.getBaseURL();
        SyndFeed syndFeed = this._rssFeed.getSyndFeed();
        List<SyndContent> syndContents = this.getSyndContents();
        StringBundler sb = new StringBundler(syndContents.size());
        for (SyndContent syndContent : syndContents) {
            if (syndContent == null || Validator.isNull((String)syndContent.getValue())) continue;
            String sanitizedValue = "";
            String feedType = syndFeed.getFeedType();
            String type = syndContent.getType();
            if (type == null) {
                type = "text/plain";
            }
            sanitizedValue = Objects.equals(RSSUtil.getFormatType((String)feedType), "atom") && (type.equals("html") || type.equals("xhtml")) ? this._sanitize(syndContent.getValue(), baseURL) : (Objects.equals(RSSUtil.getFormatType((String)feedType), "rss") && (type.equals("text/html") || type.equals("text/xhtml")) ? this._sanitize(syndContent.getValue(), baseURL) : HtmlUtil.escape((String)syndContent.getValue()));
            sb.append(sanitizedValue);
        }
        return sb.toString();
    }

    public String getSyndEnclosureLink() {
        return this._syndEnclosureLink;
    }

    public String getSyndEnclosureLinkTitle() {
        return this._syndEnclosureLinkTitle;
    }

    public SyndEntry getSyndEntry() {
        return this._syndEntry;
    }

    public String getSyndEntryLink() {
        return this._syndEntryLink;
    }

    protected List<SyndContent> getSyndContents() {
        SyndContent syndContent = this._syndEntry.getDescription();
        if (syndContent == null) {
            return this._syndEntry.getContents();
        }
        return ListUtil.toList((Object)syndContent);
    }

    private String _sanitize(String value, String baseURL) {
        block2: {
            value = StringUtil.replace((String)value, (String[])new String[]{"src=\"/", "href=\"/"}, (String[])new String[]{"src=\"" + baseURL + "/", "href=\"" + baseURL + "/"});
            try {
                value = SanitizerUtil.sanitize((long)this._themeDisplay.getCompanyGroupId(), (long)this._themeDisplay.getScopeGroupId(), (long)this._themeDisplay.getUserId(), null, (long)0L, (String)"text/html", (String)"XSS", (String)value, null);
            }
            catch (SanitizerException se) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)se, (Throwable)se);
            }
        }
        return value;
    }
}

