/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.rss.web.internal.util;

import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.util.PropsValues;
import com.liferay.rss.web.internal.configuration.RSSWebCacheConfiguration;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

public class RSSWebCacheItem
implements WebCacheItem {
    private final RSSWebCacheConfiguration _rssWebCacheConfiguration;
    private final String _url;

    public RSSWebCacheItem(RSSWebCacheConfiguration rssWebCacheConfiguration, String url) {
        this._rssWebCacheConfiguration = rssWebCacheConfiguration;
        this._url = url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object convert(String key) throws WebCacheException {
        SyndFeedInput input = new SyndFeedInput();
        try (InputStream inputStream = this._readURL();){
            SyndFeed syndFeed = input.build((Reader)new XmlReader(inputStream));
            return syndFeed;
        }
        catch (Exception e) {
            throw new WebCacheException(this._url + " " + e.toString(), (Throwable)e);
        }
    }

    public long getRefreshTime() {
        return 60000L * (long)this._rssWebCacheConfiguration.feedTime();
    }

    private InputStream _readURL() throws IOException {
        URL url = new URL(this._url);
        if ("file".equals(url.getProtocol())) {
            return url.openStream();
        }
        Http.Options options = new Http.Options();
        options.setLocation(this._url);
        options.setTimeout(PropsValues.RSS_CONNECTION_TIMEOUT);
        return HttpUtil.URLtoInputStream((Http.Options)options);
    }
}

