/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.rss.internal.export;

import com.liferay.normalizer.Normalizer;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.rss.export.RSSExporter;
import com.liferay.rss.model.SyndEnclosure;
import com.liferay.rss.model.SyndEntry;
import com.liferay.rss.model.SyndLink;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEnclosureImpl;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.feed.synd.SyndLinkImpl;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedOutput;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.IllegalDataException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RSSExporter.class})
public class RSSExporterImpl
implements RSSExporter {
    private static final String _REGEXP_STRIP = "[\\d\\w]";
    private static final Log _log = LogFactoryUtil.getLog(RSSExporterImpl.class);
    @Reference
    private Normalizer _normalizer;

    public String export(com.liferay.rss.model.SyndFeed syndFeed) {
        SyndFeed realSyndFeed = this._toRealSyndFeed(syndFeed);
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            return output.outputString(realSyndFeed);
        }
        catch (IllegalDataException illegalDataException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)illegalDataException);
            }
            this._regexpStrip(realSyndFeed);
            try {
                return output.outputString(realSyndFeed);
            }
            catch (FeedException feedException) {
                throw new SystemException((Throwable)feedException);
            }
        }
        catch (FeedException feedException) {
            throw new SystemException((Throwable)feedException);
        }
    }

    private String _regexpStrip(String text) {
        text = this._normalizer.normalizeToAscii(text);
        char[] array = text.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            String s = String.valueOf(array[i]);
            if (s.matches(_REGEXP_STRIP)) continue;
            array[i] = 32;
        }
        return new String(array);
    }

    private void _regexpStrip(SyndFeed syndFeed) {
        syndFeed.setTitle(this._regexpStrip(syndFeed.getTitle()));
        syndFeed.setDescription(this._regexpStrip(syndFeed.getDescription()));
        List syndEntries = syndFeed.getEntries();
        for (com.rometools.rome.feed.synd.SyndEntry syndEntry : syndEntries) {
            syndEntry.setTitle(this._regexpStrip(syndEntry.getTitle()));
            SyndContent syndContent = syndEntry.getDescription();
            syndContent.setValue(this._regexpStrip(syndContent.getValue()));
        }
    }

    private SyndContent _toRealSyncContent(com.liferay.rss.model.SyndContent syndContent) {
        SyndContentImpl realSyndContent = new SyndContentImpl();
        realSyndContent.setType(syndContent.getType());
        realSyndContent.setValue(syndContent.getValue());
        return realSyndContent;
    }

    private List<com.rometools.rome.feed.synd.SyndEnclosure> _toRealSyndEnclosures(List<SyndEnclosure> syndEnclosures) {
        if (syndEnclosures == null) {
            return null;
        }
        ArrayList<com.rometools.rome.feed.synd.SyndEnclosure> realSyndEnclosures = new ArrayList<com.rometools.rome.feed.synd.SyndEnclosure>();
        for (SyndEnclosure syndEnclosure : syndEnclosures) {
            SyndEnclosureImpl realSyndEnclosure = new SyndEnclosureImpl();
            realSyndEnclosure.setLength(syndEnclosure.getLength());
            realSyndEnclosure.setType(syndEnclosure.getType());
            realSyndEnclosure.setUrl(syndEnclosure.getUrl());
            realSyndEnclosures.add((com.rometools.rome.feed.synd.SyndEnclosure)realSyndEnclosure);
        }
        return realSyndEnclosures;
    }

    private List<com.rometools.rome.feed.synd.SyndEntry> _toRealSyndEntries(List<SyndEntry> syndEntries) {
        if (syndEntries == null) {
            return null;
        }
        ArrayList<com.rometools.rome.feed.synd.SyndEntry> realSyndEntries = new ArrayList<com.rometools.rome.feed.synd.SyndEntry>();
        for (SyndEntry syndEntry : syndEntries) {
            SyndEntryImpl realSyndEntry = new SyndEntryImpl();
            realSyndEntry.setAuthor(syndEntry.getAuthor());
            realSyndEntry.setDescription(this._toRealSyncContent(syndEntry.getDescription()));
            realSyndEntry.setEnclosures(this._toRealSyndEnclosures(syndEntry.getEnclosures()));
            realSyndEntry.setLink(syndEntry.getLink());
            realSyndEntry.setLinks(this._toRealSyndLinks(syndEntry.getLinks()));
            realSyndEntry.setPublishedDate(syndEntry.getPublishedDate());
            realSyndEntry.setTitle(syndEntry.getTitle());
            realSyndEntry.setUpdatedDate(syndEntry.getUpdatedDate());
            realSyndEntry.setUri(syndEntry.getUri());
            realSyndEntries.add((com.rometools.rome.feed.synd.SyndEntry)realSyndEntry);
        }
        return realSyndEntries;
    }

    private SyndFeed _toRealSyndFeed(com.liferay.rss.model.SyndFeed syndFeed) {
        SyndFeedImpl realSyndFeed = new SyndFeedImpl();
        realSyndFeed.setDescription(syndFeed.getDescription());
        realSyndFeed.setEntries(this._toRealSyndEntries(syndFeed.getEntries()));
        realSyndFeed.setFeedType(syndFeed.getFeedType());
        realSyndFeed.setLinks(this._toRealSyndLinks(syndFeed.getLinks()));
        realSyndFeed.setPublishedDate(syndFeed.getPublishedDate());
        realSyndFeed.setTitle(syndFeed.getTitle());
        realSyndFeed.setUri(syndFeed.getUri());
        return realSyndFeed;
    }

    private List<com.rometools.rome.feed.synd.SyndLink> _toRealSyndLinks(List<SyndLink> syndLinks) {
        if (syndLinks == null) {
            return null;
        }
        ArrayList<com.rometools.rome.feed.synd.SyndLink> realSyndLinks = new ArrayList<com.rometools.rome.feed.synd.SyndLink>();
        for (SyndLink syndLink : syndLinks) {
            SyndLinkImpl realSyndLink = new SyndLinkImpl();
            realSyndLink.setHref(syndLink.getHref());
            realSyndLink.setLength(syndLink.getLength());
            realSyndLink.setRel(syndLink.getRel());
            realSyndLink.setType(syndLink.getType());
            realSyndLinks.add((com.rometools.rome.feed.synd.SyndLink)realSyndLink);
        }
        return realSyndLinks;
    }
}

