/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.roles.uad.constants.RolesUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseRoleUADAnonymizer
extends DynamicQueryUADAnonymizer<Role> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected RoleLocalService roleLocalService;

    public void autoAnonymize(Role role, long userId, User anonymousUser) throws PortalException {
        if (role.getUserId() == userId) {
            role.setUserId(anonymousUser.getUserId());
            role.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(role, anonymousUser);
        }
        this.roleLocalService.updateRole(role);
    }

    public void delete(Role role) throws PortalException {
        this.roleLocalService.deleteRole(role);
    }

    public Class<Role> getTypeClass() {
        return Role.class;
    }

    protected void autoAnonymizeAssetEntry(Role role, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(role);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.roleLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return RolesUADConstants.USER_ID_FIELD_NAMES_ROLE;
    }

    protected AssetEntry fetchAssetEntry(Role role) {
        return this.assetEntryLocalService.fetchEntry(Role.class.getName(), role.getRoleId());
    }
}

