/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.uad.anonymizer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.roles.uad.constants.RolesUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseRoleUADAnonymizer
extends DynamicQueryUADAnonymizer<Role> {
    @Reference
    protected RoleLocalService roleLocalService;

    public void autoAnonymize(Role role, long userId, User anonymousUser) throws PortalException {
        if (role.getUserId() == userId) {
            role.setUserId(anonymousUser.getUserId());
            role.setUserName(anonymousUser.getFullName());
        }
        this.roleLocalService.updateRole(role);
    }

    public void delete(Role role) throws PortalException {
        this.roleLocalService.deleteRole(role);
    }

    public Class<Role> getTypeClass() {
        return Role.class;
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.roleLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return RolesUADConstants.USER_ID_FIELD_NAMES_ROLE;
    }
}

