/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.roles.item.selector.web.internal.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.util.ArrayUtil;

import javax.portlet.RenderResponse;

/**
 * @author Alessio Antonio Rendina
 */
public class RoleItemSelectorChecker extends EmptyOnClickRowChecker {

	public RoleItemSelectorChecker(
		RenderResponse renderResponse, long[] checkedRoleIds,
		String[] excludedRoleNames) {

		super(renderResponse);

		_checkedRoleIds = checkedRoleIds;
		_excludedRoleNames = excludedRoleNames;
	}

	@Override
	public boolean isChecked(Object object) {
		Role role = (Role)object;

		return ArrayUtil.contains(_checkedRoleIds, role.getRoleId());
	}

	@Override
	public boolean isDisabled(Object object) {
		Role role = (Role)object;

		return ArrayUtil.contains(_excludedRoleNames, role.getName());
	}

	private final long[] _checkedRoleIds;
	private final String[] _excludedRoleNames;

}