/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.item.selector.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portlet.rolesadmin.search.RoleSearch;
import com.liferay.portlet.rolesadmin.search.RoleSearchTerms;
import com.liferay.roles.item.selector.web.internal.search.RoleItemSelectorChecker;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class RoleItemSelectorViewDisplayContext {
    private final HttpServletRequest _httpServletRequest;
    private final String _itemSelectedEventName;
    private final PortletURL _portletURL;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final RoleLocalService _roleLocalService;
    private SearchContainer<Role> _searchContainer;
    private final int _type;
    private final UsersAdmin _usersAdmin;

    public RoleItemSelectorViewDisplayContext(RoleLocalService roleLocalService, UsersAdmin usersAdmin, HttpServletRequest httpServletRequest, PortletURL portletURL, String itemSelectedEventName, int type) {
        this._roleLocalService = roleLocalService;
        this._usersAdmin = usersAdmin;
        this._httpServletRequest = httpServletRequest;
        this._portletURL = portletURL;
        this._itemSelectedEventName = itemSelectedEventName;
        this._type = type;
        this._renderRequest = (RenderRequest)httpServletRequest.getAttribute("javax.portlet.request");
        this._renderResponse = (RenderResponse)httpServletRequest.getAttribute("javax.portlet.response");
    }

    public String getItemSelectedEventName() {
        return this._itemSelectedEventName;
    }

    public String getOrderByCol() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"name");
    }

    public String getOrderByType() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
    }

    public PortletURL getPortletURL() throws PortletException {
        PortletURL portletURL = PortletURLUtil.clone((PortletURL)this._portletURL, (MimeResponse)this._renderResponse);
        portletURL.setParameter("keywords", ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords"));
        portletURL.setParameter("type", String.valueOf(this.getType()));
        return portletURL;
    }

    public SearchContainer<Role> getSearchContainer() throws Exception {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        this._searchContainer = new RoleSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        this._searchContainer.setEmptyResultsMessage("no-roles-were-found");
        OrderByComparator orderByComparator = this._usersAdmin.getRoleOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        RoleItemSelectorChecker rowChecker = new RoleItemSelectorChecker(this._renderResponse, this.getCheckedRoleIds());
        this._searchContainer.setOrderByCol(this.getOrderByCol());
        this._searchContainer.setOrderByComparator(orderByComparator);
        this._searchContainer.setOrderByType(this.getOrderByType());
        this._searchContainer.setRowChecker((RowChecker)rowChecker);
        RoleSearchTerms searchTerms = (RoleSearchTerms)this._searchContainer.getSearchTerms();
        searchTerms.setType(this.getType());
        List results = this._roleLocalService.search(CompanyThreadLocal.getCompanyId().longValue(), searchTerms.getKeywords(), searchTerms.getTypesObj(), -1, -1, this._searchContainer.getOrderByComparator());
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            results = this._usersAdmin.filterRoles(permissionChecker, results);
        }
        this._searchContainer.setTotal(results.size());
        this._searchContainer.setResults(ListUtil.subList((List)results, (int)this._searchContainer.getStart(), (int)this._searchContainer.getEnd()));
        return this._searchContainer;
    }

    public int getType() {
        return this._type;
    }

    protected long[] getCheckedRoleIds() {
        return ParamUtil.getLongValues((PortletRequest)this._renderRequest, (String)"checkedRoleIds");
    }
}

