Liferay.Loader.define('roles-admin-web$lodash-es@4.17.15/_unicodeSize', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        /** Used to compose unicode character classes. */
        var rsAstralRange = '\\ud800-\\udfff',
            rsComboMarksRange = '\\u0300-\\u036f',
            reComboHalfMarksRange = '\\ufe20-\\ufe2f',
            rsComboSymbolsRange = '\\u20d0-\\u20ff',
            rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
            rsVarRange = '\\ufe0e\\ufe0f';

        /** Used to compose unicode capture groups. */
        var rsAstral = '[' + rsAstralRange + ']',
            rsCombo = '[' + rsComboRange + ']',
            rsFitz = '\\ud83c[\\udffb-\\udfff]',
            rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
            rsNonAstral = '[^' + rsAstralRange + ']',
            rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
            rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
            rsZWJ = '\\u200d';

        /** Used to compose unicode regexes. */
        var reOptMod = rsModifier + '?',
            rsOptVar = '[' + rsVarRange + ']?',
            rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
            rsSeq = rsOptVar + reOptMod + rsOptJoin,
            rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

        /** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
        var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

        /**
         * Gets the size of a Unicode `string`.
         *
         * @private
         * @param {string} string The string inspect.
         * @returns {number} Returns the string size.
         */
        function unicodeSize(string) {
            var result = reUnicode.lastIndex = 0;
            while (reUnicode.test(string)) {
                ++result;
            }
            return result;
        }

        export default unicodeSize;
    }
});
//# sourceMappingURL=_unicodeSize.js.map