/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleServiceUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class RoleDisplayContext {
    private static final String[] _ASSIGNEE_TYPE_NAMES = new String[]{"users", "sites", "organizations", "user-groups"};
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;

    public RoleDisplayContext(HttpServletRequest request, RenderResponse renderResponse) {
        this._request = request;
        this._renderResponse = renderResponse;
    }

    public List<NavigationItem> getEditRoleNavigationItems() throws Exception {
        long roleId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"roleId");
        Role role = RoleServiceUtil.fetchRole((long)roleId);
        if (role != null) {
            final List<String> tabsNames = this._getTabsNames();
            final Map<String, String> tabsURLs = this._getTabsURLs();
            final String tabs1 = ParamUtil.getString((HttpServletRequest)this._request, (String)"tabs1");
            return new NavigationItemList(){
                {
                    for (String tabsName : tabsNames) {
                        this.add(navigationItem -> {
                            navigationItem.setActive(tabsName.equals(tabs1));
                            navigationItem.setHref(tabsURLs.get(tabsName));
                            navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)tabsName));
                        });
                    }
                }
            };
        }
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)RoleDisplayContext.this._getCurrentURL());
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)"details"));
                });
                this.add(navigationItem -> {
                    navigationItem.setActive(false);
                    navigationItem.setDisabled(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)"define-permissions"));
                });
                int type = ParamUtil.getInteger((HttpServletRequest)RoleDisplayContext.this._request, (String)"type", (int)1);
                if (type == 1) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(false);
                        navigationItem.setDisabled(false);
                        navigationItem.setHref((Object)"");
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)"assignees"));
                    });
                }
            }
        };
    }

    public List<NavigationItem> getRoleAssignmentsNavigationItems(final PortletURL portletURL) throws Exception {
        final String tabs2 = ParamUtil.getString((HttpServletRequest)this._request, (String)"tabs2", (String)"users");
        return new NavigationItemList(){
            {
                for (String assigneeTypeName : _ASSIGNEE_TYPE_NAMES) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(assigneeTypeName.equals(tabs2));
                        navigationItem.setHref(portletURL, new Object[]{"tabs2", assigneeTypeName});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)assigneeTypeName));
                    });
                }
            }
        };
    }

    public List<NavigationItem> getSelectAssigneesNavigationItems(final PortletURL portletURL) throws Exception {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref(portletURL, new Object[]{"tabs2", "users"});
                    String tabs2 = ParamUtil.getString((HttpServletRequest)RoleDisplayContext.this._request, (String)"tabs2", (String)"users");
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)tabs2));
                });
            }
        };
    }

    public List<NavigationItem> getSelectRoleNavigationItems(final String label) {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)label));
                });
            }
        };
    }

    public List<NavigationItem> getViewRoleNavigationItems(final PortletURL portletURL) throws Exception {
        final int type = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"type", (int)1);
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(type == 1);
                    navigationItem.setHref(portletURL, new Object[]{"type", 1});
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)"regular-roles"));
                });
                this.add(navigationItem -> {
                    navigationItem.setActive(type == 2);
                    navigationItem.setHref(portletURL, new Object[]{"type", 2});
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)"site-roles"));
                });
                this.add(navigationItem -> {
                    navigationItem.setActive(type == 3);
                    navigationItem.setHref(portletURL, new Object[]{"type", 3});
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)RoleDisplayContext.this._request, (String)"organization-roles"));
                });
            }
        };
    }

    private String _getCurrentURL() {
        PortletRequest portletRequest = (PortletRequest)this._request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)this._request.getAttribute("javax.portlet.response");
        PortletURL currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)PortalUtil.getLiferayPortletRequest((PortletRequest)portletRequest), (LiferayPortletResponse)PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse));
        return currentURLObj.toString();
    }

    private List<String> _getTabsNames() throws Exception {
        String name;
        long roleId;
        Role role;
        ArrayList<String> tabsNames = new ArrayList<String>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)(role = RoleServiceUtil.fetchRole((long)(roleId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"roleId")))).getRoleId(), (String)"UPDATE")) {
            tabsNames.add("details");
        }
        if (!((name = role.getName()).equals("Administrator") || name.equals("Organization Administrator") || name.equals("Organization Owner") || name.equals("Owner") || name.equals("Site Administrator") || name.equals("Site Owner") || !RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)role.getRoleId(), (String)"DEFINE_PERMISSIONS"))) {
            tabsNames.add("define-permissions");
        }
        boolean unassignableRole = false;
        if (name.equals("Guest") || name.equals("Owner") || name.equals("User")) {
            unassignableRole = true;
        }
        if (!unassignableRole && role.getType() == 1 && RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)role.getRoleId(), (String)"ASSIGN_MEMBERS")) {
            tabsNames.add("assignees");
        }
        return tabsNames;
    }

    private Map<String, String> _getTabsURLs() throws Exception {
        String redirect = ParamUtil.getString((HttpServletRequest)this._request, (String)"redirect");
        String backURL = ParamUtil.getString((HttpServletRequest)this._request, (String)"backURL", (String)redirect);
        long roleId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"roleId");
        Role role = RoleServiceUtil.fetchRole((long)roleId);
        HashMap<String, String> tabsURLs = new HashMap<String, String>();
        PortletURL assignMembersURL = this._renderResponse.createRenderURL();
        assignMembersURL.setParameter("mvcPath", "/edit_role_assignments.jsp");
        assignMembersURL.setParameter("tabs1", "assignees");
        assignMembersURL.setParameter("redirect", backURL);
        assignMembersURL.setParameter("roleId", String.valueOf(role.getRoleId()));
        tabsURLs.put("assignees", assignMembersURL.toString());
        PortletURL definePermissionsURL = this._renderResponse.createRenderURL();
        definePermissionsURL.setParameter("mvcPath", "/edit_role_permissions.jsp");
        definePermissionsURL.setParameter("tabs1", "define-permissions");
        definePermissionsURL.setParameter("redirect", backURL);
        definePermissionsURL.setParameter("cmd", "view");
        definePermissionsURL.setParameter("roleId", String.valueOf(role.getRoleId()));
        tabsURLs.put("define-permissions", definePermissionsURL.toString());
        PortletURL editRoleURL = this._renderResponse.createRenderURL();
        editRoleURL.setParameter("mvcPath", "/edit_role.jsp");
        editRoleURL.setParameter("tabs1", "details");
        editRoleURL.setParameter("redirect", backURL);
        editRoleURL.setParameter("roleId", String.valueOf(role.getRoleId()));
        tabsURLs.put("details", editRoleURL.toString());
        return tabsURLs;
    }
}

