/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.web.internal.portlet.configuration.icon;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_roles_admin_web_portlet_RolesAdminPortlet", "path=/edit_role.jsp", "path=/edit_role_assignments.jsp"}, service={PortletConfigurationIcon.class})
public class DefinePermissionsPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    @Reference
    private Portal _portal;
    private RoleService _roleService;

    public String getMessage(PortletRequest portletRequest) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)this.getLocale(portletRequest), ((Object)((Object)this)).getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"define-permissions");
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        try {
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"com_liferay_roles_admin_web_portlet_RolesAdminPortlet", (String)"RENDER_PHASE");
            portletURL.setParameter("mvcPath", "/edit_role_permissions.jsp");
            portletURL.setParameter("cmd", "view");
            portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
            portletURL.setParameter("roleId", String.valueOf(this._getRoleId(portletRequest)));
            return portletURL.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public double getWeight() {
        return 102.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long roleId = this._getRoleId(portletRequest);
            Role role = this._roleService.fetchRole(roleId);
            String roleName = role.getName();
            return !roleName.equals("Administrator") && !roleName.equals("Site Owner") && !roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner") && !roleName.equals("Owner") && !roleName.equals("Site Administrator") && RolePermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)roleId, (String)"DEFINE_PERMISSIONS");
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Reference(unbind="-")
    protected void setRoleService(RoleService roleService) {
        this._roleService = roleService;
    }

    private long _getRoleId(PortletRequest portletRequest) {
        HttpServletRequest request = this._portal.getHttpServletRequest(portletRequest);
        return ParamUtil.getLong((HttpServletRequest)request, (String)"roleId");
    }
}

