/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.internal.role.type.contributor;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.util.PropsValues;
import com.liferay.roles.admin.role.type.contributor.RoleTypeContributor;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=200"}, service={RoleTypeContributor.class})
public class SiteRoleTypeContributor
implements RoleTypeContributor {
    @Reference
    private Portal _portal;

    public String[] getExcludedRoleNames() {
        return new String[]{"Site Administrator", "Site Owner"};
    }

    public String getIcon() {
        return "globe";
    }

    public String getName() {
        return "site";
    }

    public String[] getSubtypes() {
        return PropsValues.ROLES_SITE_SUBTYPES;
    }

    public String getTabTitle(Locale locale) {
        return "site-roles";
    }

    public String getTitle(Locale locale) {
        return "site-role";
    }

    public int getType() {
        return 2;
    }

    public boolean isAllowAssignMembers(Role role) {
        return false;
    }

    public boolean isAllowDelete(Role role) {
        if (role == null) {
            return false;
        }
        return !this._portal.isSystemRole(role.getName());
    }

    public boolean isAutomaticallyAssigned(Role role) {
        return Objects.equals("Site Member", role.getName());
    }
}

