/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.exception.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Permission;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionConversionFilter;
import com.liferay.portal.kernel.security.permission.PermissionConverterUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.roles.admin.internal.exportimport.data.handler.ImportExportPermissionConversionFilter;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class RoleStagedModelDataHandler
extends BaseStagedModelDataHandler<Role> {
    public static final String[] CLASS_NAMES = new String[]{Role.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(RoleStagedModelDataHandler.class);
    private GroupLocalService _groupLocalService;
    private final PermissionConversionFilter _permissionConversionFilter = new ImportExportPermissionConversionFilter();
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private ResourcePermissionService _resourcePermissionService;
    private RoleLocalService _roleLocalService;

    public void deleteStagedModel(Role role) throws PortalException {
        this._roleLocalService.deleteRole(role);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        Role role = this._roleLocalService.fetchRoleByUuidAndCompanyId(uuid, group.getCompanyId());
        if (role != null) {
            this.deleteStagedModel(role);
        }
    }

    public List<Role> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(this._roleLocalService.fetchRoleByUuidAndCompanyId(uuid, companyId));
        return roles;
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Role role) {
        return role.getName();
    }

    protected void deleteRolePermissions(PortletDataContext portletDataContext, Role importedRole) {
        List resourcePermissions = this._resourcePermissionLocalService.getRoleResourcePermissions(importedRole.getRoleId(), new int[]{1, 3}, -1, -1);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this._resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
        }
        List groupResourcePermissions = this._resourcePermissionLocalService.getRoleResourcePermissions(importedRole.getRoleId(), new int[]{2}, -1, -1);
        for (ResourcePermission groupResourcePermission : groupResourcePermissions) {
            long groupId = GetterUtil.getLong((String)groupResourcePermission.getPrimKey());
            if (groupId != portletDataContext.getCompanyGroupId() && groupId != portletDataContext.getUserPersonalSiteGroupId()) continue;
            this._resourcePermissionLocalService.deleteResourcePermission(groupResourcePermission);
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Role role) throws Exception {
        String permissionsPath = ExportImportPathUtil.getModelPath((StagedModel)role, (String)"permissions.xml");
        List permissions = PermissionConverterUtil.convertPermissions((Role)role, (PermissionConversionFilter)this._permissionConversionFilter);
        String xml = portletDataContext.toXML((Object)permissions);
        portletDataContext.addZipEntry(permissionsPath, xml);
        Element roleElement = portletDataContext.getExportDataElement((ClassedModel)role);
        portletDataContext.addClassedModel(roleElement, ExportImportPathUtil.getModelPath((StagedModel)role), (ClassedModel)role);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Role role) throws Exception {
        long userId = portletDataContext.getUserId(role.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)role);
        Role existingRole = this._roleLocalService.fetchRoleByUuidAndCompanyId(role.getUuid(), portletDataContext.getCompanyId());
        if (existingRole == null) {
            existingRole = this._roleLocalService.fetchRole(portletDataContext.getCompanyId(), role.getName());
        }
        Role importedRole = null;
        if (existingRole == null) {
            serviceContext.setUuid(role.getUuid());
            importedRole = this._roleLocalService.addRole(userId, null, 0L, role.getName(), role.getTitleMap(), role.getDescriptionMap(), role.getType(), role.getSubtype(), serviceContext);
        } else {
            importedRole = this._roleLocalService.updateRole(existingRole.getRoleId(), role.getName(), role.getTitleMap(), role.getDescriptionMap(), role.getSubtype(), serviceContext);
            this.deleteRolePermissions(portletDataContext, importedRole);
        }
        String permissionsPath = ExportImportPathUtil.getModelPath((StagedModel)role, (String)"permissions.xml");
        List permissions = (List)portletDataContext.getZipEntryAsObject(permissionsPath);
        for (Permission permission : permissions) {
            try {
                this.importResourcePermissions(portletDataContext, importedRole, permission);
            }
            catch (NoSuchResourceActionException nsrae) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Skip importing individually scoped permissions", (Throwable)nsrae);
            }
        }
        portletDataContext.importClassedModel((ClassedModel)role, (ClassedModel)importedRole);
    }

    protected void importResourcePermissions(PortletDataContext portletDataContext, Role importedRole, Permission permission) throws PortalException {
        int scope = permission.getScope();
        if (scope == 1) {
            this._resourcePermissionService.addResourcePermission(portletDataContext.getCompanyGroupId(), portletDataContext.getCompanyId(), permission.getName(), scope, String.valueOf(portletDataContext.getCompanyId()), importedRole.getRoleId(), permission.getActionId());
        } else if (scope == 2) {
            long groupId;
            long primaryKey = groupId = portletDataContext.getCompanyGroupId();
            long sourceGroupId = GetterUtil.getLong((String)permission.getPrimKey());
            if (sourceGroupId == portletDataContext.getSourceUserPersonalSiteGroupId()) {
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                User user = permissionChecker.getUser();
                groupId = user.getGroupId();
                primaryKey = portletDataContext.getUserPersonalSiteGroupId();
            }
            this._resourcePermissionService.addResourcePermission(groupId, portletDataContext.getCompanyId(), permission.getName(), 2, String.valueOf(primaryKey), importedRole.getRoleId(), permission.getActionId());
        } else if (scope == 3) {
            this._resourcePermissionService.addResourcePermission(0L, portletDataContext.getCompanyId(), permission.getName(), 3, String.valueOf(0L), importedRole.getRoleId(), permission.getActionId());
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)"Individually scoped permissions are not imported");
        }
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    @Reference(unbind="-")
    protected void setResourcePermissionService(ResourcePermissionService resourcePermissionService) {
        this._resourcePermissionService = resourcePermissionService;
    }

    @Reference(unbind="-")
    protected void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }
}

