/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.SearchOrderByUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import com.liferay.roles.admin.search.RoleDisplayTerms;
import com.liferay.roles.admin.search.RoleSearchTerms;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class RoleSearch
extends SearchContainer<Role> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-roles-were-found";
    public static List<String> headerNames = new ArrayList<String>(){
        {
            this.add("title");
            this.add("type");
            if (PropsValues.ROLES_ORGANIZATION_SUBTYPES.length > 0 || PropsValues.ROLES_REGULAR_SUBTYPES.length > 0 || PropsValues.ROLES_SITE_SUBTYPES.length > 0) {
                this.add("subtype");
            }
            this.add("description");
        }
    };
    public static Map<String, String> orderableHeaders = HashMapBuilder.put((Object)"description", (Object)"description").put((Object)"title", (Object)"title").put((Object)"type", (Object)"type").build();
    private static final Log _log = LogFactoryUtil.getLog(RoleSearch.class);

    public RoleSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new RoleDisplayTerms(portletRequest), (DisplayTerms)new RoleSearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        RoleDisplayTerms displayTerms = (RoleDisplayTerms)this.getDisplayTerms();
        if (ParamUtil.getInteger((PortletRequest)portletRequest, (String)"type") == 0) {
            displayTerms.setType(1);
            RoleSearchTerms searchTerms = (RoleSearchTerms)this.getSearchTerms();
            searchTerms.setType(1);
        }
        iteratorURL.setParameter("description", displayTerms.getDescription());
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("type", String.valueOf(displayTerms.getType()));
        try {
            this.setOrderableHeaders(orderableHeaders);
            String portletId = PortletProviderUtil.getPortletId((String)Role.class.getName(), (PortletProvider.Action)PortletProvider.Action.BROWSE);
            String orderByCol = SearchOrderByUtil.getOrderByCol((PortletRequest)portletRequest, (String)portletId, (String)"roles-order-by-col", (String)"title");
            this.setOrderByCol(orderByCol);
            String orderByType = SearchOrderByUtil.getOrderByType((PortletRequest)portletRequest, (String)portletId, (String)"roles-order-by-type", (String)"asc");
            this.setOrderByComparator(UsersAdminUtil.getRoleOrderByComparator((String)orderByCol, (String)orderByType));
            this.setOrderByType(orderByType);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize role search", (Throwable)exception);
        }
    }
}

