/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.role.apio.internal.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.CollectionResource;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.role.apio.identifier.RoleIdentifier;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class RoleCollectionResource
implements CollectionResource<Role, Long, RoleIdentifier> {
    @Reference
    private RoleService _roleService;

    public CollectionRoutes<Role, Long> collectionRoutes(CollectionRoutes.Builder<Role, Long> builder) {
        return builder.addGetter(this::_getPageItems, Company.class).build();
    }

    public String getName() {
        return "roles";
    }

    public ItemRoutes<Role, Long> itemRoutes(ItemRoutes.Builder<Role, Long> builder) {
        return builder.addGetter(roleIdentifier -> this._roleService.getRole(roleIdentifier.longValue())).build();
    }

    public Representor<Role> representor(Representor.Builder<Role, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("Role", new String[0]).identifier(RoleModel::getRoleId).addBoolean("systemRole", Role::isSystem)).addBoolean("teamRole", Role::isTeam)).addDate("dateCreated", RoleModel::getCreateDate)).addDate("dateModified", RoleModel::getModifiedDate)).addLinkedModel("creator", PersonIdentifier.class, RoleModel::getUserId)).addLocalizedStringByLocale("description", RoleModel::getDescription)).addString("name", RoleModel::getName)).addString("type", Role::getTypeLabel)).build();
    }

    private PageItems<Role> _getPageItems(Pagination pagination, Company company) {
        List roles = this._roleService.search(company.getCompanyId(), null, null, null, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._roleService.searchCount(company.getCompanyId(), null, null, null);
        return new PageItems((Collection)roles, count);
    }
}

