/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry.internal;

import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistrar;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.dependency.ServiceDependencyManager;
import com.liferay.registry.internal.FilterWrapper;
import com.liferay.registry.internal.MapWrapper;
import com.liferay.registry.internal.ServiceReferenceWrapper;
import com.liferay.registry.internal.ServiceRegistrationWrapper;
import com.liferay.registry.internal.ServiceTrackerCustomizerAdapter;
import com.liferay.registry.internal.ServiceTrackerWrapper;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;

public class RegistryImpl
implements Registry {
    private final BundleContext _bundleContext;
    private final ReferenceQueue<org.osgi.util.tracker.ServiceTracker<?, ?>> _referenceQueue = new ReferenceQueue();
    private final Set<ServiceDependencyManager> _serviceDependencyManagers = new HashSet<ServiceDependencyManager>();
    private final Set<Reference<org.osgi.util.tracker.ServiceTracker<?, ?>>> _serviceTrackerReferences = Collections.newSetFromMap(new ConcurrentHashMap());

    public RegistryImpl(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R> R callService(Class<S> serviceClass, Function<S, R> function) {
        org.osgi.framework.ServiceReference serviceReference = this._bundleContext.getServiceReference(serviceClass);
        if (serviceReference == null) {
            return function.apply(null);
        }
        Object service = this._bundleContext.getService(serviceReference);
        try {
            R r = function.apply(service);
            return r;
        }
        finally {
            this._bundleContext.ungetService(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R> R callService(String className, Function<S, R> function) {
        org.osgi.framework.ServiceReference serviceReference = this._bundleContext.getServiceReference(className);
        if (serviceReference == null) {
            return function.apply(null);
        }
        Object service = this._bundleContext.getService(serviceReference);
        try {
            R r = function.apply(service);
            return r;
        }
        finally {
            this._bundleContext.ungetService(serviceReference);
        }
    }

    public void closeServiceTrackers() {
        Iterator<Reference<org.osgi.util.tracker.ServiceTracker<?, ?>>> iterator = this._serviceTrackerReferences.iterator();
        while (iterator.hasNext()) {
            Reference<org.osgi.util.tracker.ServiceTracker<?, ?>> serviceTrackerReference = iterator.next();
            iterator.remove();
            org.osgi.util.tracker.ServiceTracker<?, ?> serviceTracker = serviceTrackerReference.get();
            if (serviceTracker == null) continue;
            try {
                serviceTracker.close();
            }
            catch (Throwable throwable) {}
        }
        while (this._referenceQueue.poll() != null) {
        }
    }

    public <T> ServiceReference<T>[] getAllServiceReferences(String className, String filterString) throws Exception {
        org.osgi.framework.ServiceReference[] osgiServiceReferences = this._bundleContext.getAllServiceReferences(className, filterString);
        if (osgiServiceReferences == null) {
            return null;
        }
        return RegistryImpl._toServiceReferences(osgiServiceReferences);
    }

    public Filter getFilter(String filterString) throws RuntimeException {
        try {
            return new FilterWrapper(this._bundleContext.createFilter(filterString));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException(invalidSyntaxException);
        }
    }

    public Registry getRegistry() throws SecurityException {
        return this;
    }

    @Deprecated
    public <T> T getService(Class<T> clazz) {
        org.osgi.framework.ServiceReference serviceReference = this._bundleContext.getServiceReference(clazz);
        if (serviceReference == null) {
            return null;
        }
        return (T)this._bundleContext.getService(serviceReference);
    }

    public <T> T getService(ServiceReference<T> serviceReference) {
        if (!(serviceReference instanceof ServiceReferenceWrapper)) {
            throw new IllegalArgumentException();
        }
        ServiceReferenceWrapper serviceReferenceWrapper = (ServiceReferenceWrapper)serviceReference;
        return (T)this._bundleContext.getService(serviceReferenceWrapper.getServiceReference());
    }

    @Deprecated
    public <T> T getService(String className) {
        org.osgi.framework.ServiceReference serviceReference = this._bundleContext.getServiceReference(className);
        if (serviceReference == null) {
            return null;
        }
        return (T)this._bundleContext.getService(serviceReference);
    }

    public Collection<ServiceDependencyManager> getServiceDependencyManagers() {
        return Collections.unmodifiableCollection(this._serviceDependencyManagers);
    }

    public <T> ServiceReference<T> getServiceReference(Class<T> clazz) {
        org.osgi.framework.ServiceReference serviceReference = this._bundleContext.getServiceReference(clazz);
        if (serviceReference == null) {
            return null;
        }
        return new ServiceReferenceWrapper(serviceReference);
    }

    public <T> ServiceReference<T> getServiceReference(String className) {
        org.osgi.framework.ServiceReference serviceReference = this._bundleContext.getServiceReference(className);
        if (serviceReference == null) {
            return null;
        }
        return new ServiceReferenceWrapper(serviceReference);
    }

    public <T> Collection<ServiceReference<T>> getServiceReferences(Class<T> clazz, String filterString) throws Exception {
        Collection osgiServiceReferences = this._bundleContext.getServiceReferences(clazz, filterString);
        if (osgiServiceReferences.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ServiceReference<T>> serviceReferences = new ArrayList<ServiceReference<T>>(osgiServiceReferences.size());
        for (org.osgi.framework.ServiceReference osgiServiceReference : osgiServiceReferences) {
            ServiceReferenceWrapper serviceReference = new ServiceReferenceWrapper(osgiServiceReference);
            serviceReferences.add(serviceReference);
        }
        return serviceReferences;
    }

    public <T> ServiceReference<T>[] getServiceReferences(String className, String filterString) throws Exception {
        org.osgi.framework.ServiceReference[] osgiServiceReferences = this._bundleContext.getServiceReferences(className, filterString);
        if (osgiServiceReferences == null) {
            return null;
        }
        return RegistryImpl._toServiceReferences(osgiServiceReferences);
    }

    public <T> ServiceRegistrar<T> getServiceRegistrar(Class<T> clazz) {
        return new ServiceRegistrar((Registry)this, clazz);
    }

    public <T> Collection<T> getServices(Class<T> clazz, String filterString) throws Exception {
        Collection serviceReferences = this._bundleContext.getServiceReferences(clazz, filterString);
        if (serviceReferences.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> services = new ArrayList<Object>();
        for (org.osgi.framework.ServiceReference serviceReference : serviceReferences) {
            Object service = this._bundleContext.getService(serviceReference);
            if (service == null) continue;
            services.add(service);
        }
        return services;
    }

    public <T> T[] getServices(String className, String filterString) throws Exception {
        org.osgi.framework.ServiceReference[] serviceReferences = this._bundleContext.getServiceReferences(className, filterString);
        if (serviceReferences == null) {
            return null;
        }
        Object service = this._bundleContext.getService(serviceReferences[0]);
        Object[] services = (Object[])Array.newInstance(service.getClass(), serviceReferences.length);
        services[0] = service;
        for (int i = 1; i < serviceReferences.length; ++i) {
            org.osgi.framework.ServiceReference serviceReference = serviceReferences[i];
            service = this._bundleContext.getService(serviceReference);
            if (service == null) continue;
            services[i] = service;
        }
        return services;
    }

    public String getSymbolicName(ClassLoader classLoader) {
        if (classLoader instanceof BundleReference) {
            BundleReference bundleReference = (BundleReference)classLoader;
            Bundle bundle = bundleReference.getBundle();
            return bundle.getSymbolicName();
        }
        return null;
    }

    public <T> ServiceRegistration<T> registerService(Class<T> clazz, T service) {
        return this.registerService(clazz, service, null);
    }

    public <T> ServiceRegistration<T> registerService(Class<T> clazz, T service, Map<String, Object> properties) {
        properties = this._addBundleContextProperties(properties);
        org.osgi.framework.ServiceRegistration serviceRegistration = this._bundleContext.registerService(clazz, service, (Dictionary)new MapWrapper(properties));
        return new ServiceRegistrationWrapper(serviceRegistration);
    }

    public <T> ServiceRegistration<T> registerService(String className, T service) {
        return this.registerService(className, service, null);
    }

    public <T> ServiceRegistration<T> registerService(String className, T service, Map<String, Object> properties) {
        properties = this._addBundleContextProperties(properties);
        org.osgi.framework.ServiceRegistration serviceRegistration = this._bundleContext.registerService(className, service, (Dictionary)new MapWrapper(properties));
        return new ServiceRegistrationWrapper(serviceRegistration);
    }

    public <T> ServiceRegistration<T> registerService(String[] classNames, T service) {
        return this.registerService(classNames, service, null);
    }

    public <T> ServiceRegistration<T> registerService(String[] classNames, T service, Map<String, Object> properties) {
        properties = this._addBundleContextProperties(properties);
        org.osgi.framework.ServiceRegistration serviceRegistration = this._bundleContext.registerService(classNames, service, (Dictionary)new MapWrapper(properties));
        return new ServiceRegistrationWrapper(serviceRegistration);
    }

    public synchronized void registerServiceDependencyManager(ServiceDependencyManager serviceDependencyManager) {
        this._serviceDependencyManagers.add(serviceDependencyManager);
    }

    public Registry setRegistry(Registry registry) throws SecurityException {
        return registry;
    }

    public <S, T> ServiceTracker<S, T> trackServices(Class<S> clazz) {
        org.osgi.util.tracker.ServiceTracker serviceTracker = new org.osgi.util.tracker.ServiceTracker(this._bundleContext, clazz, null);
        this.addServiceTracker(serviceTracker);
        return new ServiceTrackerWrapper(serviceTracker);
    }

    public <S, T> ServiceTracker<S, T> trackServices(Class<S> clazz, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        org.osgi.util.tracker.ServiceTracker serviceTracker = new org.osgi.util.tracker.ServiceTracker(this._bundleContext, clazz, new ServiceTrackerCustomizerAdapter<S, T>(serviceTrackerCustomizer));
        this.addServiceTracker(serviceTracker);
        return new ServiceTrackerWrapper(serviceTracker);
    }

    public <S, T> ServiceTracker<S, T> trackServices(Filter filter) {
        if (!(filter instanceof FilterWrapper)) {
            throw new IllegalArgumentException();
        }
        FilterWrapper filterWrapper = (FilterWrapper)filter;
        org.osgi.util.tracker.ServiceTracker serviceTracker = new org.osgi.util.tracker.ServiceTracker(this._bundleContext, filterWrapper.getFilter(), null);
        this.addServiceTracker(serviceTracker);
        return new ServiceTrackerWrapper(serviceTracker);
    }

    public <S, T> ServiceTracker<S, T> trackServices(Filter filter, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        if (!(filter instanceof FilterWrapper)) {
            throw new IllegalArgumentException();
        }
        FilterWrapper filterWrapper = (FilterWrapper)filter;
        org.osgi.util.tracker.ServiceTracker serviceTracker = new org.osgi.util.tracker.ServiceTracker(this._bundleContext, filterWrapper.getFilter(), new ServiceTrackerCustomizerAdapter<S, T>(serviceTrackerCustomizer));
        this.addServiceTracker(serviceTracker);
        return new ServiceTrackerWrapper(serviceTracker);
    }

    public <S, T> ServiceTracker<S, T> trackServices(String className) {
        org.osgi.util.tracker.ServiceTracker serviceTracker = new org.osgi.util.tracker.ServiceTracker(this._bundleContext, className, null);
        this.addServiceTracker(serviceTracker);
        return new ServiceTrackerWrapper(serviceTracker);
    }

    public <S, T> ServiceTracker<S, T> trackServices(String className, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        org.osgi.util.tracker.ServiceTracker serviceTracker = new org.osgi.util.tracker.ServiceTracker(this._bundleContext, className, new ServiceTrackerCustomizerAdapter<S, T>(serviceTrackerCustomizer));
        this.addServiceTracker(serviceTracker);
        return new ServiceTrackerWrapper(serviceTracker);
    }

    public <T> boolean ungetService(ServiceReference<T> serviceReference) {
        if (!(serviceReference instanceof ServiceReferenceWrapper)) {
            throw new IllegalArgumentException();
        }
        ServiceReferenceWrapper serviceReferenceWrapper = (ServiceReferenceWrapper)serviceReference;
        return this._bundleContext.ungetService(serviceReferenceWrapper.getServiceReference());
    }

    public void unregisterServiceDependencyManager(ServiceDependencyManager serviceDependencyManager) {
        this._serviceDependencyManagers.remove(serviceDependencyManager);
    }

    protected void addServiceTracker(org.osgi.util.tracker.ServiceTracker<?, ?> serviceTracker) {
        Reference reference = new WeakReference(serviceTracker, this._referenceQueue);
        this._serviceTrackerReferences.add(reference);
        while ((reference = this._referenceQueue.poll()) != null) {
            this._serviceTrackerReferences.remove(reference);
        }
        return;
    }

    private static <T> ServiceReference<T>[] _toServiceReferences(org.osgi.framework.ServiceReference<T>[] osgiServiceReferences) {
        ServiceReference[] serviceReferences = new ServiceReference[osgiServiceReferences.length];
        for (int i = 0; i < osgiServiceReferences.length; ++i) {
            org.osgi.framework.ServiceReference<T> osgiServiceReference = osgiServiceReferences[i];
            serviceReferences[i] = new ServiceReferenceWrapper<T>(osgiServiceReference);
        }
        return serviceReferences;
    }

    private Map<String, Object> _addBundleContextProperties(Map<String, Object> properties) {
        Bundle bundle = this._bundleContext.getBundle();
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        properties.put("bundle.id", bundle.getBundleId());
        properties.put("bundle.symbolic.name", bundle.getSymbolicName());
        properties.put("bundle.version", bundle.getVersion());
        return properties;
    }
}

