/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry.dependency;

import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.dependency.ServiceDependency;
import com.liferay.registry.dependency.ServiceDependencyListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ServiceDependencyManager {
    private final Set<ServiceDependency> _serviceDependencies = new HashSet<ServiceDependency>();
    private final Set<ServiceDependencyListener> _serviceDependencyListeners = new HashSet<ServiceDependencyListener>();

    public ServiceDependencyManager() {
        Registry registry = RegistryUtil.getRegistry();
        registry.registerServiceDependencyManager(this);
    }

    public void addServiceDependencyListener(ServiceDependencyListener serviceDependencyListener) {
        this._serviceDependencyListeners.add(serviceDependencyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        for (ServiceDependencyListener serviceDependencyListener : this._serviceDependencyListeners) {
            serviceDependencyListener.destroy();
        }
        this._serviceDependencyListeners.clear();
        Set<ServiceDependency> set = this._serviceDependencies;
        synchronized (set) {
            for (ServiceDependency serviceDependency : this._serviceDependencies) {
                serviceDependency.close();
            }
        }
        this._serviceDependencies.clear();
        Registry registry = RegistryUtil.getRegistry();
        registry.unregisterServiceDependencyManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependencies(Class<?> ... serviceClasses) {
        Set<ServiceDependency> set = this._serviceDependencies;
        synchronized (set) {
            this.doRegisterDependencies(serviceClasses);
            for (ServiceDependency serviceDependency : this._serviceDependencies) {
                serviceDependency.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependencies(Class<?>[] serviceClasses, Filter[] filters) {
        Set<ServiceDependency> set = this._serviceDependencies;
        synchronized (set) {
            this.doRegisterDependencies(serviceClasses);
            this.doRegisterDependencies(filters);
            for (ServiceDependency serviceDependency : this._serviceDependencies) {
                serviceDependency.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependencies(Collection<Class<?>> serviceClasses, Collection<Filter> filters) {
        Set<ServiceDependency> set = this._serviceDependencies;
        synchronized (set) {
            this.doRegisterDependencies(serviceClasses.toArray(new Class[serviceClasses.size()]));
            this.doRegisterDependencies(filters.toArray(new Filter[filters.size()]));
            for (ServiceDependency serviceDependency : this._serviceDependencies) {
                serviceDependency.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependencies(Filter ... filters) {
        Set<ServiceDependency> set = this._serviceDependencies;
        synchronized (set) {
            this.doRegisterDependencies(filters);
            for (ServiceDependency serviceDependency : this._serviceDependencies) {
                serviceDependency.open();
            }
        }
    }

    public void removeServiceDependencyListener(ServiceDependencyListener serviceDependencyListener) {
        this._serviceDependencyListeners.remove(serviceDependencyListener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(3);
        sb.append("{serviceDependencies=");
        sb.append(this._serviceDependencies);
        sb.append("}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyDependencies() {
        Set<ServiceDependency> set = this._serviceDependencies;
        synchronized (set) {
            for (ServiceDependency serviceDependency : this._serviceDependencies) {
                if (serviceDependency.isFulfilled()) continue;
                return;
            }
            this._serviceDependencies.notifyAll();
            for (ServiceDependencyListener serviceDependencyListener : this._serviceDependencyListeners) {
                serviceDependencyListener.dependenciesFulfilled();
            }
            this.destroy();
        }
    }

    public void waitForDependencies() {
        this.waitForDependencies(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDependencies(long timeout) {
        Set<ServiceDependency> set = this._serviceDependencies;
        synchronized (set) {
            if (this._serviceDependencies.isEmpty()) {
                return;
            }
            boolean missingServiceDependencies = false;
            for (ServiceDependency serviceDependency : this._serviceDependencies) {
                if (serviceDependency.isFulfilled()) continue;
                missingServiceDependencies = true;
                break;
            }
            if (missingServiceDependencies) {
                try {
                    this._serviceDependencies.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected void doRegisterDependencies(Class<?>[] serviceClasses) {
        Registry registry = RegistryUtil.getRegistry();
        for (Class<?> serviceClass : serviceClasses) {
            ServiceDependency serviceDependency = new ServiceDependency(serviceClass);
            this._serviceDependencies.add(serviceDependency);
            ServiceTracker<Object, Object> serviceTracker = registry.trackServices(serviceClass, new ServiceDependencyServiceTrackerCustomizer(serviceDependency));
            serviceDependency.setServiceTracker(serviceTracker);
        }
    }

    protected void doRegisterDependencies(Filter[] filters) {
        Registry registry = RegistryUtil.getRegistry();
        for (Filter filter : filters) {
            ServiceDependency serviceDependency = new ServiceDependency(filter);
            this._serviceDependencies.add(serviceDependency);
            ServiceTracker<Object, Object> serviceTracker = registry.trackServices(filter, new ServiceDependencyServiceTrackerCustomizer(serviceDependency));
            serviceDependency.setServiceTracker(serviceTracker);
        }
    }

    private class ServiceDependencyServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private final ServiceDependency _serviceDependency;

        public ServiceDependencyServiceTrackerCustomizer(ServiceDependency serviceDependency) {
            this._serviceDependency = serviceDependency;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object addingService(ServiceReference<Object> serviceReference) {
            Set set = ServiceDependencyManager.this._serviceDependencies;
            synchronized (set) {
                Registry registry = RegistryUtil.getRegistry();
                Object service = registry.getService(serviceReference);
                this._serviceDependency.fulfilled(serviceReference);
                ServiceDependencyManager.this.verifyDependencies();
                return service;
            }
        }

        @Override
        public void modifiedService(ServiceReference<Object> serviceReference, Object service) {
        }

        @Override
        public void removedService(ServiceReference<Object> serviceReference, Object service) {
        }
    }
}

