/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry;

import com.liferay.registry.Registry;
import com.liferay.registry.ServiceFinalizer;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceRegistrar<T> {
    private volatile boolean _destroyed;
    private final Registry _registry;
    private final Set<ServiceRegistration<T>> _serviceRegistrations = Collections.newSetFromMap(new ConcurrentHashMap());

    public ServiceRegistrar(Registry registry, Class<T> clazz) {
        this._registry = registry;
    }

    public void destroy() {
        this.destroy(null);
    }

    public void destroy(ServiceFinalizer<T> serviceFinalizer) {
        this._destroyed = true;
        for (ServiceRegistration<T> serviceRegistration : this._serviceRegistrations) {
            if (serviceFinalizer != null) {
                ServiceReference<T> serviceReference = serviceRegistration.getServiceReference();
                T service = this._registry.getService(serviceReference);
                serviceFinalizer.finalize(serviceReference, service);
            }
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
    }

    public Collection<ServiceRegistration<T>> getServiceRegistrations() {
        if (this._destroyed) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this._serviceRegistrations);
    }

    public boolean isDestroyed() {
        return this._destroyed;
    }

    public ServiceRegistration<T> registerService(Class<T> clazz, T service) {
        if (this._destroyed) {
            return null;
        }
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(clazz, service);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(Class<T> clazz, T service, Map<String, Object> properties) {
        if (this._destroyed) {
            return null;
        }
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(clazz, service, properties);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(String className, T service) {
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(className, service);
        if (this._destroyed) {
            return null;
        }
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(String className, T service, Map<String, Object> properties) {
        if (this._destroyed) {
            return null;
        }
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(className, service, properties);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(String[] classNames, T service) {
        if (this._destroyed) {
            return null;
        }
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(classNames, service);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(String[] classNames, T service, Map<String, Object> properties) {
        if (this._destroyed) {
            return null;
        }
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(classNames, service, properties);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }
}

