/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry;

import com.liferay.registry.ServiceReference;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ServiceRankingUtil {
    public static int compare(ServiceReference<?> serviceReference1, ServiceReference<?> serviceReference2) {
        int value = Integer.compare(ServiceRankingUtil._getServiceRanking(serviceReference1), ServiceRankingUtil._getServiceRanking(serviceReference2));
        if (value != 0) {
            return value;
        }
        return -Long.compare((Long)serviceReference1.getProperty("service.id"), (Long)serviceReference2.getProperty("service.id"));
    }

    public static <S, T> Optional<Map.Entry<ServiceReference<S>, T>> getHighestRankingEntry(Map<ServiceReference<S>, T> services) {
        Set<Map.Entry<ServiceReference<S>, T>> entrySet = services.entrySet();
        Stream stream = entrySet.stream();
        return stream.max(Comparator.comparing(Map.Entry::getKey, ServiceRankingUtil::compare));
    }

    private static int _getServiceRanking(ServiceReference<?> serviceReference) {
        Object serviceRanking = serviceReference.getProperty("service.ranking");
        if (serviceRanking instanceof Integer) {
            return (Integer)serviceRanking;
        }
        if (serviceRanking instanceof String) {
            try {
                return Integer.parseInt((String)serviceRanking);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

