/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.push.notifications.model.PushNotificationsDevice;
import com.liferay.push.notifications.service.base.PushNotificationsDeviceServiceBaseImpl;
import java.util.List;

public class PushNotificationsDeviceServiceImpl
extends PushNotificationsDeviceServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PushNotificationsDeviceServiceImpl.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(PushNotificationsDeviceServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.push.notifications");

    @AccessControlled(guestAccessEnabled=true)
    public PushNotificationsDevice addPushNotificationsDevice(String token, String platform) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), 0L, "MANAGE_DEVICES");
        PushNotificationsDevice pushNotificationsDevice = this.pushNotificationsDevicePersistence.fetchByToken(token);
        if (pushNotificationsDevice == null) {
            pushNotificationsDevice = this.pushNotificationsDeviceLocalService.addPushNotificationsDevice(this.getGuestOrUserId(), platform, token);
        } else if (!platform.equals("sms")) {
            long userId = this.getGuestOrUserId();
            pushNotificationsDevice.setUserId(userId);
            this.pushNotificationsDeviceLocalService.updatePushNotificationsDevice(pushNotificationsDevice);
        }
        return pushNotificationsDevice;
    }

    public PushNotificationsDevice deletePushNotificationsDevice(long pushNotificationsDeviceId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), 0L, "MANAGE_DEVICES");
        return this.pushNotificationsDeviceLocalService.deletePushNotificationsDevice(pushNotificationsDeviceId);
    }

    @AccessControlled(guestAccessEnabled=true)
    public PushNotificationsDevice deletePushNotificationsDevice(String token) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), 0L, "MANAGE_DEVICES");
        PushNotificationsDevice pushNotificationsDevice = this.pushNotificationsDevicePersistence.fetchByToken(token);
        if (pushNotificationsDevice == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("No device found with token " + token));
            }
        } else {
            long userId = this.getGuestOrUserId();
            if (pushNotificationsDevice.getUserId() == userId) {
                pushNotificationsDevice = this.pushNotificationsDeviceLocalService.deletePushNotificationsDevice(token);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Device found with token ", token, " does not belong to user ", String.valueOf(userId)}));
            }
        }
        return pushNotificationsDevice;
    }

    public void sendPushNotification(long[] toUserIds, String payload) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), 0L, "SEND_PUSH_NOTIFICATION");
        JSONObject payloadJSONObject = JSONFactoryUtil.createJSONObject((String)payload);
        this.pushNotificationsDeviceLocalService.sendPushNotification(toUserIds, payloadJSONObject);
    }

    public void sendPushNotification(String platform, List<String> tokens, String payload) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), 0L, "SEND_PUSH_NOTIFICATION");
        JSONObject payloadJSONObject = JSONFactoryUtil.createJSONObject((String)payload);
        this.pushNotificationsDeviceLocalService.sendPushNotification(platform, tokens, payloadJSONObject);
    }
}

