/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.service.impl;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.push.notifications.model.PushNotificationsDevice;
import com.liferay.push.notifications.sender.BaseResponse;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import com.liferay.push.notifications.service.base.PushNotificationsDeviceLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class PushNotificationsDeviceLocalServiceImpl
extends PushNotificationsDeviceLocalServiceBaseImpl {
    private ServiceTrackerMap<String, PushNotificationsSender> _serviceTrackerMap;

    public PushNotificationsDevice addPushNotificationsDevice(long userId, String platform, String token) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long pushNotificationsDeviceId = this.counterLocalService.increment();
        PushNotificationsDevice pushNotificationsDevice = this.pushNotificationsDevicePersistence.create(pushNotificationsDeviceId);
        pushNotificationsDevice.setCompanyId(user.getCompanyId());
        pushNotificationsDevice.setUserId(user.getUserId());
        pushNotificationsDevice.setCreateDate(new Date());
        pushNotificationsDevice.setPlatform(platform);
        pushNotificationsDevice.setToken(token);
        this.pushNotificationsDevicePersistence.update((BaseModel)pushNotificationsDevice);
        return pushNotificationsDevice;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Bundle bundle = FrameworkUtil.getBundle(PushNotificationsDeviceLocalServiceImpl.class);
        BundleContext bundleContext = bundle.getBundleContext();
        this._serviceTrackerMap = ServiceTrackerMapFactory.singleValueMap((BundleContext)bundleContext, PushNotificationsSender.class, (String)"platform");
        this._serviceTrackerMap.open();
    }

    public PushNotificationsDevice deletePushNotificationsDevice(String token) throws PortalException {
        PushNotificationsDevice pushNotificationsDevice = this.pushNotificationsDevicePersistence.findByToken(token);
        this.pushNotificationsDevicePersistence.remove((BaseModel)pushNotificationsDevice);
        return pushNotificationsDevice;
    }

    @Override
    public void destroy() {
        super.destroy();
        this._serviceTrackerMap.close();
    }

    public List<PushNotificationsDevice> getPushNotificationsDevices(int start, int end, OrderByComparator<PushNotificationsDevice> orderByComparator) {
        return this.pushNotificationsDevicePersistence.findAll(start, end, orderByComparator);
    }

    public void sendPushNotification(long[] toUserIds, JSONObject payloadJSONObject) throws PortalException {
        for (String platform : this._serviceTrackerMap.keySet()) {
            ArrayList<String> tokens = new ArrayList<String>();
            List pushNotificationsDevices = this.pushNotificationsDevicePersistence.findByU_P(toUserIds, platform, -1, -1);
            for (PushNotificationsDevice pushNotificationsDevice : pushNotificationsDevices) {
                tokens.add(pushNotificationsDevice.getToken());
            }
            if (tokens.isEmpty()) continue;
            this.sendPushNotification(platform, tokens, payloadJSONObject);
        }
    }

    public void sendPushNotification(String platform, List<String> tokens, JSONObject payloadJSONObject) throws PortalException {
        PushNotificationsSender pushNotificationsSender = (PushNotificationsSender)this._serviceTrackerMap.getService((Object)platform);
        if (pushNotificationsSender == null) {
            return;
        }
        Throwable exception = null;
        try {
            pushNotificationsSender.send(tokens, payloadJSONObject);
        }
        catch (PortalException pe) {
            exception = pe;
            throw pe;
        }
        catch (Exception e) {
            exception = e;
            throw new PortalException((Throwable)e);
        }
        finally {
            if (exception != null) {
                MessageBusUtil.sendMessage((String)"liferay/push_notification_response", (Object)new BaseResponse(platform, (Exception)exception));
            }
        }
    }

    public void updateToken(String oldToken, String newToken) throws PortalException {
        PushNotificationsDevice oldPushNotificationsDevice = this.deletePushNotificationsDevice(oldToken);
        PushNotificationsDevice newPushNotificationsDevice = this.pushNotificationsDevicePersistence.fetchByToken(newToken);
        if (newPushNotificationsDevice == null) {
            this.addPushNotificationsDevice(oldPushNotificationsDevice.getUserId(), oldPushNotificationsDevice.getPlatform(), newToken);
        }
    }
}

