/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.apple.internal.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.push.notifications.sender.Response;
import com.liferay.push.notifications.sender.apple.internal.AppleResponse;
import com.liferay.push.notifications.service.PushNotificationsDeviceLocalService;
import com.notnoop.apns.DeliveryError;

public class ApplePushNotificationsResponseMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ApplePushNotificationsResponseMessageListener.class);
    private final PushNotificationsDeviceLocalService _pushNotificationsDeviceLocalService;

    public ApplePushNotificationsResponseMessageListener(PushNotificationsDeviceLocalService pushNotificationsDeviceLocalService) {
        this._pushNotificationsDeviceLocalService = pushNotificationsDeviceLocalService;
    }

    protected void doReceive(Message message) throws Exception {
        String status;
        Response response = (Response)message.getPayload();
        if (response.isSucceeded() || !(response instanceof AppleResponse)) {
            return;
        }
        AppleResponse appleResponse = (AppleResponse)response;
        String invalidTokenErrorName = DeliveryError.INVALID_TOKEN.name();
        if (invalidTokenErrorName.equals(status = appleResponse.getStatus())) {
            String token = appleResponse.getToken();
            try {
                this._pushNotificationsDeviceLocalService.deletePushNotificationsDevice(token);
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Token " + token + " is invalid and was deleted"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

