/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.apple.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.push.notifications.exception.PushNotificationsException;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import com.liferay.push.notifications.sender.apple.internal.AppleDelegate;
import com.liferay.push.notifications.sender.apple.internal.configuration.ApplePushNotificationsSenderConfiguration;
import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.ApnsServiceBuilder;
import com.notnoop.apns.PayloadBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.push.notifications.sender.apple.internal.configuration.ApplePushNotificationsSenderConfiguration"}, immediate=true, property={"platform=apple"})
public class ApplePushNotificationsSender
implements PushNotificationsSender {
    public static final String PLATFORM = "apple";
    private static final Log _log = LogFactoryUtil.getLog(ApplePushNotificationsSender.class);
    private volatile ApnsService _apnsService;

    public void send(List<String> tokens, JSONObject payloadJSONObject) throws Exception {
        if (this._apnsService == null) {
            throw new PushNotificationsException("Apple push notifications sender is not configured properly");
        }
        String payload = this.buildPayload(payloadJSONObject);
        this._apnsService.push(tokens, payload);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        ApnsServiceBuilder appleServiceBuilder;
        ApplePushNotificationsSenderConfiguration applePushNotificationsSenderConfiguration;
        block18: {
            applePushNotificationsSenderConfiguration = (ApplePushNotificationsSenderConfiguration)ConfigurableUtil.createConfigurable(ApplePushNotificationsSenderConfiguration.class, properties);
            String certificatePath = applePushNotificationsSenderConfiguration.certificatePath();
            String certificatePassword = applePushNotificationsSenderConfiguration.certificatePassword();
            if (Validator.isNull((String)certificatePath) || Validator.isNull((String)certificatePassword)) {
                this._apnsService = null;
                return;
            }
            appleServiceBuilder = APNS.newService();
            try (InputStream inputStream = this._getCertificateInputStream(certificatePath);){
                if (inputStream == null) {
                    throw new IllegalArgumentException("Unable to find Apple certificate at " + certificatePath);
                }
                appleServiceBuilder.withCert(inputStream, certificatePassword);
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block18;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
        appleServiceBuilder.withDelegate((ApnsDelegate)new AppleDelegate());
        if (applePushNotificationsSenderConfiguration.sandbox()) {
            appleServiceBuilder.withSandboxDestination();
        } else {
            appleServiceBuilder.withProductionDestination();
        }
        this._apnsService = appleServiceBuilder.build();
    }

    protected String buildPayload(JSONObject payloadJSONObject) {
        String sound;
        boolean silent;
        JSONArray bodyLocalizedArgumentsJSONArray;
        String bodyLocalizedKey;
        String body;
        PayloadBuilder builder = PayloadBuilder.newPayload();
        if (payloadJSONObject.has("badge")) {
            builder.badge(payloadJSONObject.getInt("badge"));
        }
        if (Validator.isNotNull((String)(body = payloadJSONObject.getString("body")))) {
            builder.alertBody(body);
        }
        if (Validator.isNotNull((String)(bodyLocalizedKey = payloadJSONObject.getString("bodyLocalizedKey")))) {
            builder.localizedKey(bodyLocalizedKey);
        }
        if ((bodyLocalizedArgumentsJSONArray = payloadJSONObject.getJSONArray("bodyLocalizedArguments")) != null) {
            ArrayList<String> localizedArguments = new ArrayList<String>();
            for (int i = 0; i < bodyLocalizedArgumentsJSONArray.length(); ++i) {
                localizedArguments.add(bodyLocalizedArgumentsJSONArray.getString(i));
            }
            builder.localizedArguments(localizedArguments);
        }
        if (silent = payloadJSONObject.getBoolean("silent")) {
            builder.instantDeliveryOrSilentNotification();
        }
        if (Validator.isNotNull((String)(sound = payloadJSONObject.getString("sound")))) {
            builder.sound(sound);
        }
        JSONObject newPayloadJSONObject = JSONFactoryUtil.createJSONObject();
        Iterator iterator = payloadJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.equals("badge") || key.equals("body") || key.equals("bodyLocalizedKey") || key.equals("bodyLocalizedArguments") || key.equals("sound") || key.equals("silent")) continue;
            newPayloadJSONObject.put(key, payloadJSONObject.get(key));
        }
        builder.customField("payload", (Object)newPayloadJSONObject.toString());
        return builder.build();
    }

    @Deactivate
    protected void deactivate() {
        this._apnsService = null;
    }

    private InputStream _getCertificateInputStream(String certificatePath) {
        try {
            return new FileInputStream(certificatePath);
        }
        catch (FileNotFoundException fnfe) {
            ClassLoader classLoader = ApplePushNotificationsSender.class.getClassLoader();
            return classLoader.getResourceAsStream(certificatePath);
        }
    }
}

