/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.internal.TlsTunnelBuilder;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.NetworkIOException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.Date;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsFeedbackConnection {
    private static final Logger logger = LoggerFactory.getLogger(ApnsFeedbackConnection.class);
    private final SocketFactory factory;
    private final String host;
    private final int port;
    private final Proxy proxy;
    private final int readTimeout;
    private final int connectTimeout;
    private final String proxyUsername;
    private final String proxyPassword;
    int DELAY_IN_MS = 1000;
    private static final int RETRIES = 3;

    public ApnsFeedbackConnection(SocketFactory factory, String host, int port) {
        this(factory, host, port, null, 0, 0, null, null);
    }

    public ApnsFeedbackConnection(SocketFactory factory, String host, int port, Proxy proxy, int readTimeout, int connectTimeout, String proxyUsername, String proxyPassword) {
        this.factory = factory;
        this.host = host;
        this.port = port;
        this.proxy = proxy;
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    public Map<String, Date> getInactiveDevices() throws NetworkIOException {
        int attempts = 0;
        while (true) {
            try {
                ++attempts;
                Map<String, Date> result = this.getInactiveDevicesImpl();
                attempts = 0;
                return result;
            }
            catch (Exception e) {
                logger.warn("Failed to retrieve invalid devices", (Throwable)e);
                if (attempts >= 3) {
                    logger.error("Couldn't get feedback connection", (Throwable)e);
                    Utilities.wrapAndThrowAsRuntimeException(e);
                }
                Utilities.sleep(this.DELAY_IN_MS);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Date> getInactiveDevicesImpl() throws IOException {
        Map<String, Date> map;
        Socket proxySocket = null;
        Socket socket = null;
        try {
            if (this.proxy == null) {
                socket = this.factory.createSocket(this.host, this.port);
            } else if (this.proxy.type() == Proxy.Type.HTTP) {
                TlsTunnelBuilder tunnelBuilder = new TlsTunnelBuilder();
                socket = tunnelBuilder.build((SSLSocketFactory)this.factory, this.proxy, this.proxyUsername, this.proxyPassword, this.host, this.port);
            } else {
                proxySocket = new Socket(this.proxy);
                proxySocket.connect(new InetSocketAddress(this.host, this.port), this.connectTimeout);
                socket = ((SSLSocketFactory)this.factory).createSocket(proxySocket, this.host, this.port, false);
            }
            socket.setSoTimeout(this.readTimeout);
            socket.setKeepAlive(true);
            InputStream stream = socket.getInputStream();
            map = Utilities.parseFeedbackStream(stream);
        }
        catch (Throwable throwable) {
            Utilities.close(socket);
            Utilities.close(proxySocket);
            throw throwable;
        }
        Utilities.close(socket);
        Utilities.close(proxySocket);
        return map;
    }
}

