/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.NetworkIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

abstract class AbstractApnsService
implements ApnsService {
    private ApnsFeedbackConnection feedback;
    private AtomicInteger c = new AtomicInteger();

    public AbstractApnsService(ApnsFeedbackConnection feedback) {
        this.feedback = feedback;
    }

    @Override
    public EnhancedApnsNotification push(String deviceToken, String payload) throws NetworkIOException {
        EnhancedApnsNotification notification = new EnhancedApnsNotification(this.c.incrementAndGet(), Integer.MAX_VALUE, deviceToken, payload);
        this.push(notification);
        return notification;
    }

    @Override
    public EnhancedApnsNotification push(String deviceToken, String payload, Date expiry) throws NetworkIOException {
        EnhancedApnsNotification notification = new EnhancedApnsNotification(this.c.incrementAndGet(), (int)(expiry.getTime() / 1000L), deviceToken, payload);
        this.push(notification);
        return notification;
    }

    @Override
    public EnhancedApnsNotification push(byte[] deviceToken, byte[] payload) throws NetworkIOException {
        EnhancedApnsNotification notification = new EnhancedApnsNotification(this.c.incrementAndGet(), Integer.MAX_VALUE, deviceToken, payload);
        this.push(notification);
        return notification;
    }

    @Override
    public EnhancedApnsNotification push(byte[] deviceToken, byte[] payload, int expiry) throws NetworkIOException {
        EnhancedApnsNotification notification = new EnhancedApnsNotification(this.c.incrementAndGet(), expiry, deviceToken, payload);
        this.push(notification);
        return notification;
    }

    public Collection<EnhancedApnsNotification> push(Collection<String> deviceTokens, String payload) throws NetworkIOException {
        byte[] messageBytes = Utilities.toUTF8Bytes(payload);
        ArrayList<EnhancedApnsNotification> notifications = new ArrayList<EnhancedApnsNotification>(deviceTokens.size());
        for (String deviceToken : deviceTokens) {
            byte[] dtBytes = Utilities.decodeHex(deviceToken);
            EnhancedApnsNotification notification = new EnhancedApnsNotification(this.c.incrementAndGet(), Integer.MAX_VALUE, dtBytes, messageBytes);
            notifications.add(notification);
            this.push(notification);
        }
        return notifications;
    }

    public Collection<EnhancedApnsNotification> push(Collection<String> deviceTokens, String payload, Date expiry) throws NetworkIOException {
        byte[] messageBytes = Utilities.toUTF8Bytes(payload);
        ArrayList<EnhancedApnsNotification> notifications = new ArrayList<EnhancedApnsNotification>(deviceTokens.size());
        for (String deviceToken : deviceTokens) {
            byte[] dtBytes = Utilities.decodeHex(deviceToken);
            EnhancedApnsNotification notification = new EnhancedApnsNotification(this.c.incrementAndGet(), (int)(expiry.getTime() / 1000L), dtBytes, messageBytes);
            notifications.add(notification);
            this.push(notification);
        }
        return notifications;
    }

    public Collection<EnhancedApnsNotification> push(Collection<byte[]> deviceTokens, byte[] payload) throws NetworkIOException {
        ArrayList<EnhancedApnsNotification> notifications = new ArrayList<EnhancedApnsNotification>(deviceTokens.size());
        for (byte[] deviceToken : deviceTokens) {
            EnhancedApnsNotification notification = new EnhancedApnsNotification(this.c.incrementAndGet(), Integer.MAX_VALUE, deviceToken, payload);
            notifications.add(notification);
            this.push(notification);
        }
        return notifications;
    }

    public Collection<EnhancedApnsNotification> push(Collection<byte[]> deviceTokens, byte[] payload, int expiry) throws NetworkIOException {
        ArrayList<EnhancedApnsNotification> notifications = new ArrayList<EnhancedApnsNotification>(deviceTokens.size());
        for (byte[] deviceToken : deviceTokens) {
            EnhancedApnsNotification notification = new EnhancedApnsNotification(this.c.incrementAndGet(), expiry, deviceToken, payload);
            notifications.add(notification);
            this.push(notification);
        }
        return notifications;
    }

    @Override
    public abstract void push(ApnsNotification var1) throws NetworkIOException;

    @Override
    public Map<String, Date> getInactiveDevices() throws NetworkIOException {
        return this.feedback.getInactiveDevices();
    }
}

