/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.apple.internal;

import com.liferay.push.notifications.sender.BaseResponse;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.DeliveryError;

public class AppleResponse
extends BaseResponse {
    protected int expiry;
    protected boolean resent;

    public AppleResponse(ApnsNotification apnsNotification, boolean resent) {
        this(apnsNotification);
        this.resent = resent;
        this.succeeded = true;
    }

    public AppleResponse(ApnsNotification apnsNotification, Throwable throwable) {
        this(apnsNotification);
        this.status = throwable.getMessage();
    }

    public AppleResponse(int identifier, DeliveryError deliveryError) {
        this(null);
        this.id = String.valueOf(identifier);
        this.status = deliveryError.name();
    }

    public int getExpiry() {
        return this.expiry;
    }

    public boolean isResent() {
        return this.resent;
    }

    protected AppleResponse(ApnsNotification apnsNotification) {
        super("apple");
        if (apnsNotification != null) {
            this.expiry = apnsNotification.getExpiry();
            this.id = String.valueOf(apnsNotification.getIdentifier());
            this.payload = new String(apnsNotification.getPayload());
            this.token = this.getHexadecimalString(apnsNotification.getDeviceToken());
        }
    }

    protected String getHexadecimalString(byte[] token) {
        StringBuilder sb = new StringBuilder();
        for (byte b : token) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

