/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.apple.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.push.notifications.exception.PushNotificationsException;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import com.liferay.push.notifications.sender.apple.internal.AppleDelegate;
import com.liferay.push.notifications.sender.apple.internal.configuration.ApplePushNotificationsSenderConfiguration;
import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.ApnsServiceBuilder;
import com.notnoop.apns.PayloadBuilder;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.push.notifications.sender.apple.internal.configuration.ApplePushNotificationsSenderConfiguration"}, immediate=true, property={"platform=apple"})
public class ApplePushNotificationsSender
implements PushNotificationsSender {
    public static final String PLATFORM = "apple";
    private volatile ApnsService _apnsService;

    public void send(List<String> tokens, JSONObject payloadJSONObject) throws Exception {
        if (this._apnsService == null) {
            throw new PushNotificationsException("Apple push notifications sender is not configured properly");
        }
        String payload = this.buildPayload(payloadJSONObject);
        this._apnsService.push(tokens, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        ApplePushNotificationsSenderConfiguration applePushNotificationsSenderConfiguration = (ApplePushNotificationsSenderConfiguration)ConfigurableUtil.createConfigurable(ApplePushNotificationsSenderConfiguration.class, properties);
        String certificatePath = applePushNotificationsSenderConfiguration.certificatePath();
        String certificatePassword = applePushNotificationsSenderConfiguration.certificatePassword();
        if (Validator.isNull((String)certificatePath) || Validator.isNull((String)certificatePassword)) {
            this._apnsService = null;
            return;
        }
        ApnsServiceBuilder appleServiceBuilder = APNS.newService();
        InputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(certificatePath);
            }
            catch (FileNotFoundException fnfe) {
                ClassLoader classLoader = ApplePushNotificationsSender.class.getClassLoader();
                inputStream = classLoader.getResourceAsStream(certificatePath);
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("Unable to find Apple certificate at " + certificatePath);
            }
            appleServiceBuilder.withCert(inputStream, certificatePassword);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        appleServiceBuilder.withDelegate(new AppleDelegate());
        if (applePushNotificationsSenderConfiguration.sandbox()) {
            appleServiceBuilder.withSandboxDestination();
        } else {
            appleServiceBuilder.withProductionDestination();
        }
        this._apnsService = appleServiceBuilder.build();
    }

    protected String buildPayload(JSONObject payloadJSONObject) {
        String sound;
        boolean silent;
        JSONArray bodyLocalizedArgumentsJSONArray;
        String bodyLocalizedKey;
        String body;
        PayloadBuilder builder = PayloadBuilder.newPayload();
        if (payloadJSONObject.has("badge")) {
            builder.badge(payloadJSONObject.getInt("badge"));
        }
        if (Validator.isNotNull((String)(body = payloadJSONObject.getString("body")))) {
            builder.alertBody(body);
        }
        if (Validator.isNotNull((String)(bodyLocalizedKey = payloadJSONObject.getString("bodyLocalizedKey")))) {
            builder.localizedKey(bodyLocalizedKey);
        }
        if ((bodyLocalizedArgumentsJSONArray = payloadJSONObject.getJSONArray("bodyLocalizedArguments")) != null) {
            ArrayList<String> localizedArguments = new ArrayList<String>();
            for (int i = 0; i < bodyLocalizedArgumentsJSONArray.length(); ++i) {
                localizedArguments.add(bodyLocalizedArgumentsJSONArray.getString(i));
            }
            builder.localizedArguments(localizedArguments);
        }
        if (silent = payloadJSONObject.getBoolean("silent")) {
            builder.instantDeliveryOrSilentNotification();
        }
        if (Validator.isNotNull((String)(sound = payloadJSONObject.getString("sound")))) {
            builder.sound(sound);
        }
        payloadJSONObject.remove("badge");
        payloadJSONObject.remove("body");
        payloadJSONObject.remove("bodyLocalizedKey");
        payloadJSONObject.remove("bodyLocalizedArguments");
        payloadJSONObject.remove("silent");
        payloadJSONObject.remove("sound");
        builder.customField("payload", payloadJSONObject.toString());
        return builder.build();
    }

    @Deactivate
    protected void deactivate() {
        this._apnsService = null;
    }
}

