Liferay.Loader.define("product-navigation-control-menu@5.0.18/js/useDragAndDrop", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', 'frontend-js-react-web$react-dnd-html5-backend', './AddPanel', './addPortlet', './constants/layoutDataItemTypes', './constants/positions'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.useDropTarget = exports.useDropClear = exports.useDragSymbol = exports.useDragItem = exports.DragAndDropProvider = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _reactDndHtml5Backend = require("frontend-js-react-web$react-dnd-html5-backend");

  var _AddPanel = require("./AddPanel");

  var _addPortlet = _interopRequireDefault(require("./addPortlet"));

  var _layoutDataItemTypes = require("./constants/layoutDataItemTypes");

  var _positions = require("./constants/positions");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var DROP_OVER_CLASS = 'yui3-dd-drop-over';
  var initialDragDrop = {
    dragIndicatorPosition: {},
    dropTargetColumn: null,
    dropTargetItem: null,
    setDragIndicatorPosition: function setDragIndicatorPosition() {
      return null;
    },
    setDropTargetColumn: function setDropTargetColumn() {
      return null;
    },
    setDropTargetItem: function setDropTargetItem() {
      return null;
    }
  };

  var DragAndDropContext = _react["default"].createContext(initialDragDrop);

  var DragAndDropProvider = DragAndDropContext.Provider;
  exports.DragAndDropProvider = DragAndDropProvider;

  var useDragItem = function useDragItem(sourceItem) {
    var getSourceItem = (0, _react.useCallback)(function () {
      return sourceItem;
    }, [sourceItem]);
    var sourceRef = (0, _react.useRef)(null);

    var _useDrag = (0, _reactDnd.useDrag)({
      collect: function collect(monitor) {
        return {
          isDraggingSource: monitor.isDragging()
        };
      },
      item: {
        data: sourceItem.data,
        disabled: sourceItem.disabled,
        getSourceItem: getSourceItem,
        icon: sourceItem.icon,
        itemId: sourceItem.itemId,
        name: sourceItem.name,
        type: sourceItem.type
      }
    }),
        _useDrag2 = _slicedToArray(_useDrag, 3),
        isDraggingSource = _useDrag2[0].isDraggingSource,
        handlerRef = _useDrag2[1],
        previewRef = _useDrag2[2];

    (0, _react.useEffect)(function () {
      previewRef((0, _reactDndHtml5Backend.getEmptyImage)(), {
        captureDraggingState: true
      });
    }, [previewRef]);
    return {
      handlerRef: handlerRef,
      isDraggingSource: isDraggingSource,
      sourceRef: sourceRef
    };
  };

  exports.useDragItem = useDragItem;

  var useDragSymbol = function useDragSymbol(_ref) {
    var data = _ref.data,
        icon = _ref.icon,
        label = _ref.label,
        portletId = _ref.portletId,
        type = _ref.type;
    var sourceItem = (0, _react.useMemo)(function () {
      return {
        data: data,
        icon: icon,
        isSymbol: true,
        itemId: portletId,
        name: label,
        type: type
      };
    }, [data, icon, label, portletId, type]);

    var _useDragItem = useDragItem(sourceItem),
        handlerRef = _useDragItem.handlerRef,
        isDraggingSource = _useDragItem.isDraggingSource,
        sourceRef = _useDragItem.sourceRef;

    return {
      isDraggingSource: isDraggingSource,
      sourceRef: function symbolRef(element) {
        sourceRef.current = element;
        handlerRef(element);
      }
    };
  };

  exports.useDragSymbol = useDragSymbol;

  var useDropClear = function useDropClear(targetItem) {
    var _useContext = (0, _react.useContext)(DragAndDropContext),
        dropTargetColumn = _useContext.dropTargetColumn,
        setDropTargetColumn = _useContext.setDropTargetColumn;

    var _useDrop = (0, _reactDnd.useDrop)({
      accept: Object.values(_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES),
      hover: function hover(item, monitor) {
        if (!monitor.isOver({
          shallow: true
        })) {
          return;
        }

        if (dropTargetColumn) {
          dropTargetColumn.classList.remove(DROP_OVER_CLASS);
        }

        setDropTargetColumn(null);
      }
    }),
        _useDrop2 = _slicedToArray(_useDrop, 2),
        setDropClearRef = _useDrop2[1];

    setDropClearRef(targetItem);
  };

  exports.useDropClear = useDropClear;

  var useDropTarget = function useDropTarget(targetItem) {
    var _useContext2 = (0, _react.useContext)(DragAndDropContext),
        dropTargetColumn = _useContext2.dropTargetColumn,
        dropTargetItem = _useContext2.dropTargetItem,
        setDragIndicatorPosition = _useContext2.setDragIndicatorPosition,
        setDropTargetColumn = _useContext2.setDropTargetColumn,
        setDropTargetItem = _useContext2.setDropTargetItem;

    var _useState = (0, _react.useState)(0),
        _useState2 = _slicedToArray(_useState, 2),
        windowScrollPosition = _useState2[0],
        setWindowScrollPosition = _useState2[1];

    var _useState3 = (0, _react.useState)(null),
        _useState4 = _slicedToArray(_useState3, 2),
        targetPosition = _useState4[0],
        setTargetPosition = _useState4[1];

    var _useContext3 = (0, _react.useContext)(_AddPanel.AddPanelContext),
        plid = _useContext3.plid,
        setWidgets = _useContext3.setWidgets,
        widgets = _useContext3.widgets;

    (0, _react.useEffect)(function () {
      var handleWindowScroll = function handleWindowScroll() {
        setWindowScrollPosition(window.scrollY);
      };

      window.addEventListener('scroll', handleWindowScroll);
      return function () {
        window.removeEventListener('scroll', handleWindowScroll);
      };
    }, []);

    var _useDrop3 = (0, _reactDnd.useDrop)({
      accept: Object.values(_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES),
      drop: function drop(item, monitor) {
        setDropTargetColumn(null);

        if (!monitor.isOver({
          shallow: true
        })) {
          return;
        }

        if (!item.disabled) {
          dropTargetColumn.classList.remove(DROP_OVER_CLASS);
          (0, _addPortlet["default"])({
            item: item,
            plid: plid,
            targetItem: targetItem,
            targetPosition: targetPosition
          });

          if (!item.data.instanceable) {
            var updatedWidgets = (0, _AddPanel.updateUsedWidget)({
              item: item,
              widgets: widgets
            });
            setWidgets(updatedWidgets);
          }
        }
      },
      hover: function hover(item, monitor) {
        if (!monitor.isOver({
          shallow: true
        })) {
          return;
        }

        var itemIsDropzone = targetItem.classList.contains('portlet-dropzone');
        var parentTargetItem = itemIsDropzone ? targetItem.parentElement : targetItem.parentElement.parentElement;

        if (dropTargetColumn !== parentTargetItem) {
          if (dropTargetColumn) {
            dropTargetColumn.classList.remove(DROP_OVER_CLASS);
          }

          setDropTargetColumn(parentTargetItem);

          if (itemIsDropzone) {
            parentTargetItem.classList.add(DROP_OVER_CLASS);
          }
        }

        var dropPosition = getDropPosition({
          monitor: monitor,
          targetItem: targetItem
        });
        setTargetPosition(dropPosition);

        if (dropTargetItem !== targetItem || dropPosition !== targetPosition) {
          setDropTargetItem(targetItem);
          var dropIndicatorPosition = getDropIndicatorPosition({
            monitor: monitor,
            targetItem: targetItem,
            windowScrollPosition: windowScrollPosition
          });
          setDragIndicatorPosition(dropIndicatorPosition);
        }
      }
    }),
        _useDrop4 = _slicedToArray(_useDrop3, 2),
        setDropTargetRef = _useDrop4[1];

    setDropTargetRef(targetItem);
  };

  exports.useDropTarget = useDropTarget;

  var getHoverPosition = function getHoverPosition(monitor, targetItem) {
    var clientOffset = monitor.getClientOffset();
    var targetItemBoundingRect = targetItem.getBoundingClientRect();
    var targetItemHeight = targetItem.getBoundingClientRect().height;

    var hoverClientY = clientOffset.y - targetItemBoundingRect.top;
    return {
      hoverClientY: hoverClientY,
      hoverTopLimit: targetItemHeight / 2,
      targetItemBoundingRect: targetItemBoundingRect
    };
  };

  var getDropIndicatorPosition = function getDropIndicatorPosition(_ref2) {
    var monitor = _ref2.monitor,
        targetItem = _ref2.targetItem,
        windowScrollPosition = _ref2.windowScrollPosition;

    var _getHoverPosition = getHoverPosition(monitor, targetItem),
        hoverClientY = _getHoverPosition.hoverClientY,
        hoverTopLimit = _getHoverPosition.hoverTopLimit,
        targetItemBoundingRect = _getHoverPosition.targetItemBoundingRect;

    var positionY = hoverClientY < hoverTopLimit ? targetItemBoundingRect.top : targetItemBoundingRect.bottom;
    return {
      clientX: targetItemBoundingRect.left,
      clientY: positionY + windowScrollPosition,
      width: targetItemBoundingRect.width
    };
  };

  var getDropPosition = function getDropPosition(_ref3) {
    var monitor = _ref3.monitor,
        targetItem = _ref3.targetItem;

    var _getHoverPosition2 = getHoverPosition(monitor, targetItem),
        hoverClientY = _getHoverPosition2.hoverClientY,
        hoverTopLimit = _getHoverPosition2.hoverTopLimit;

    return hoverClientY < hoverTopLimit ? _positions.POSITIONS.top : _positions.POSITIONS.bottom;
  };
  //# sourceMappingURL=useDragAndDrop.js.map
});
//# sourceMappingURL=useDragAndDrop.js.map