Liferay.Loader.define("product-navigation-control-menu@5.0.18/js/addPortlet", ['module', 'exports', 'require', 'frontend-js-web', './addLoadingAnimation', './constants/layoutDataItemTypes'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _addLoadingAnimation = _interopRequireDefault(require("./addLoadingAnimation"));

  var _layoutDataItemTypes = require("./constants/layoutDataItemTypes");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var addPortlet = function addPortlet(_ref) {
    var item = _ref.item,
        plid = _ref.plid,
        targetItem = _ref.targetItem,
        targetPosition = _ref.targetPosition;
    var loading = (0, _addLoadingAnimation["default"])(targetItem, targetPosition);
    (0, _frontendJsWeb.openToast)({
      message: Liferay.Language.get('the-application-was-added-to-the-page'),
      type: 'success'
    });
    var portletData = item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.widget ? '' : "".concat(item.data.classPK, ",").concat(item.data.className);
    Liferay.Portlet.add({
      beforePortletLoaded: function beforePortletLoaded() {
        return null;
      },
      placeHolder: loading,
      plid: plid,
      portletData: portletData,
      portletId: item.data.portletId,
      portletItemId: item.data.portletItemId || ''
    });
  };

  var _default = addPortlet;
  exports["default"] = _default;
  //# sourceMappingURL=addPortlet.js.map
});
//# sourceMappingURL=addPortlet.js.map