Liferay.Loader.define("product-navigation-control-menu@5.0.18/js/TabsContent", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './AddPanel', './Collection', './ContentOptions', './SearchForm', './SearchResultPanel'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _AddPanel = require("./AddPanel");

  var _Collection = _interopRequireDefault(require("./Collection"));

  var _ContentOptions = _interopRequireDefault(require("./ContentOptions"));

  var _SearchForm = _interopRequireDefault(require("./SearchForm"));

  var _SearchResultPanel = _interopRequireDefault(require("./SearchResultPanel"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var CONTENT_TAB_ID = 'content';
  var EMPTY_COLLECTIONS = {
    collections: []
  };
  var INITIAL_EXPANDED_ITEM_COLLECTIONS = 3;

  var TabsContent = function TabsContent(_ref) {
    var tab = _ref.tab,
        tabIndex = _ref.tabIndex;

    var _useContext = (0, _react.useContext)(_AddPanel.AddPanelContext),
        getContentsURL = _useContext.getContentsURL,
        namespace = _useContext.namespace;

    var _useState = (0, _react.useState)(tab),
        _useState2 = _slicedToArray(_useState, 2),
        filteredContent = _useState2[0],
        setFilteredContent = _useState2[1];

    var _useState3 = (0, _react.useState)(0),
        _useState4 = _slicedToArray(_useState3, 2),
        totalItems = _useState4[0],
        setTotalItems = _useState4[1];

    var _useState5 = (0, _react.useState)(''),
        _useState6 = _slicedToArray(_useState5, 2),
        searchValue = _useState6[0],
        setSearchValue = _useState6[1];

    var isContentTab = tab.id === CONTENT_TAB_ID;
    var collections = isContentTab ? filteredContent.collections : tab.collections;
    var filteredWidgets = (0, _react.useMemo)(function () {
      return searchValue ? [_objectSpread({}, tab, {
        collections: collectionFilter(tab.collections, searchValue)
      })] : tab;
    }, [searchValue, tab]);
    (0, _react.useEffect)(function () {
      if (searchValue || totalItems) {
        var body = _defineProperty({}, "".concat(namespace, "keywords"), searchValue.toLowerCase());

        if (totalItems) {
          body["".concat(namespace, "delta")] = totalItems;
        }

        (0, _frontendJsWeb.fetch)(getContentsURL, {
          body: (0, _frontendJsWeb.objectToFormData)(body),
          method: 'post'
        }).then(function (response) {
          return response.json();
        }).then(function (items) {
          var normalizedItems = _objectSpread({}, tab, {
            collections: items.contents.length ? tab.collections.map(function (collection) {
              return _objectSpread({}, collection, {
                children: items.contents.map(_AddPanel.normalizeContent)
              });
            }) : items.contents
          });

          return setFilteredContent(normalizedItems);
        })["catch"](function () {
          return setFilteredContent([EMPTY_COLLECTIONS]);
        });
      } else {
        return setFilteredContent(tab);
      }
    }, [getContentsURL, namespace, searchValue, tab, totalItems]);
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_SearchForm["default"], {
      onChange: setSearchValue,
      tabIndex: tabIndex,
      value: searchValue
    }), isContentTab && _react["default"].createElement(_ContentOptions["default"], {
      onChangeSelect: setTotalItems
    }), searchValue ? _react["default"].createElement(_SearchResultPanel["default"], {
      alertTitle: isContentTab ? Liferay.Language.get('there-is-no-content-on-this-page') : Liferay.Language.get('there-are-no-widgets-on-this-page'),
      filteredTabs: isContentTab ? [filteredContent] : filteredWidgets
    }) : _react["default"].createElement("ul", {
      className: "list-unstyled"
    }, collections.map(function (collection, index) {
      return _react["default"].createElement(_Collection["default"], {
        collection: collection,
        isContentTab: isContentTab,
        key: index,
        open: index < INITIAL_EXPANDED_ITEM_COLLECTIONS
      });
    })));
  };

  var collectionFilter = function collectionFilter(collections, searchValue) {
    var searchValueLowerCase = searchValue.toLowerCase();

    var itemFilter = function itemFilter(item) {
      return item.label.toLowerCase().indexOf(searchValueLowerCase) !== -1;
    };

    return collections.reduce(function (acc, collection) {
      if (itemFilter(collection)) {
        return [].concat(_toConsumableArray(acc), [collection]);
      } else {
        var _collection$collectio3;

        var updateCollection = _objectSpread({}, collection, {
          children: collection.children.filter(itemFilter)
        }, ((_collection$collectio3 = collection.collections) === null || _collection$collectio3 === void 0 ? void 0 : _collection$collectio3.length) && {
          collections: collectionFilter(collection.collections, searchValueLowerCase)
        });

        return [].concat(_toConsumableArray(acc), [updateCollection]);
      }
    }, []).filter(function hasChildren(collection) {
      var _collection$children, _collection$collectio, _collection$collectio2;

      if ((_collection$children = collection.children) === null || _collection$children === void 0 ? void 0 : _collection$children.length) {
        return true;
      }

      return (_collection$collectio = (_collection$collectio2 = collection.collections) === null || _collection$collectio2 === void 0 ? void 0 : _collection$collectio2.some(hasChildren)) !== null && _collection$collectio !== void 0 ? _collection$collectio : false;
    });
  };

  var _default = TabsContent;
  exports["default"] = _default;
  //# sourceMappingURL=TabsContent.js.map
});
//# sourceMappingURL=TabsContent.js.map