Liferay.Loader.define("product-navigation-control-menu@5.0.18/js/DragPreview", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var DragPreview = function DragPreview(_ref) {
    var rtl = _ref.rtl;
    var ref = (0, _react.useRef)();

    var _useDragLayer = (0, _reactDnd.useDragLayer)(function (monitor) {
      return {
        currentOffset: monitor.getClientOffset(),
        isDragging: monitor.isDragging(),
        item: monitor.getItem()
      };
    }),
        currentOffset = _useDragLayer.currentOffset,
        isDragging = _useDragLayer.isDragging,
        item = _useDragLayer.item;

    if (!isDragging) {
      return null;
    }

    return _react["default"].createElement("div", {
      className: "sidebar__drag-preview"
    }, _react["default"].createElement("div", {
      className: "sidebar__drag-preview__content text-truncate",
      ref: ref,
      style: getItemStyles(currentOffset, ref, rtl)
    }, item && item.icon && _react["default"].createElement(_icon["default"], {
      className: "mr-3",
      symbol: item.icon
    }), item && item.name ? item.name : Liferay.Language.get('element')));
  };

  var getItemStyles = function getItemStyles(currentOffset, ref, rtl) {
    if (!currentOffset || !ref.current) {
      return {
        display: 'none'
      };
    }

    var rect = ref.current.getBoundingClientRect();
    var x = rtl ? currentOffset.x + rect.width * 0.5 - window.innerWidth : currentOffset.x - rect.width * 0.5;
    var y = currentOffset.y - rect.height * 0.5;
    var transform = "translate(".concat(x, "px, ").concat(y, "px)");
    return {
      WebkitTransform: transform,
      transform: transform
    };
  };

  var _default = DragPreview;
  exports["default"] = _default;
  //# sourceMappingURL=DragPreview.js.map
});
//# sourceMappingURL=DragPreview.js.map