Liferay.Loader.define("product-navigation-control-menu@5.0.18/js/AddPanel", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', 'frontend-js-react-web$react-dnd-html5-backend', './DragAndDrop', './DragPreview', './TabsPanel', './constants/layoutDataItemTypes'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.normalizeContent = exports.updateUsedWidget = exports.AddPanelContext = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _reactDndHtml5Backend = require("frontend-js-react-web$react-dnd-html5-backend");

  var _DragAndDrop = _interopRequireDefault(require("./DragAndDrop"));

  var _DragPreview = _interopRequireDefault(require("./DragPreview"));

  var _TabsPanel = _interopRequireDefault(require("./TabsPanel"));

  var _layoutDataItemTypes = require("./constants/layoutDataItemTypes");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var INITIAL_STATE = {
    addContentsURLs: null,
    contents: null,
    displayGrid: false,
    getContentsURL: null,
    namespace: null,
    plid: null,
    portletNamespace: null,
    setDisplayGrid: function setDisplayGrid() {
      return null;
    },
    setWidgets: function setWidgets() {
      return null;
    },
    widgets: null
  };

  var AddPanelContext = _react["default"].createContext(INITIAL_STATE);

  exports.AddPanelContext = AddPanelContext;
  var AddPanelContextProvider = AddPanelContext.Provider;

  var AddPanel = function AddPanel(_ref) {
    var addContentsURLs = _ref.addContentsURLs,
        contents = _ref.contents,
        getContentsURL = _ref.getContentsURL,
        languageDirection = _ref.languageDirection,
        languageId = _ref.languageId,
        namespace = _ref.namespace,
        plid = _ref.plid,
        portletNamespace = _ref.portletNamespace,
        widgetsItems = _ref.widgets;

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        displayGrid = _useState2[0],
        setDisplayGrid = _useState2[1];

    var _useState3 = (0, _react.useState)(widgetsItems),
        _useState4 = _slicedToArray(_useState3, 2),
        widgets = _useState4[0],
        setWidgets = _useState4[1];

    var rtl = languageDirection[languageId] === 'rtl';
    (0, _react.useEffect)(function () {
      var removePortlet = function removePortlet(item) {
        var portlet = _objectSpread({}, item, {
          itemId: item.portletId
        });

        var updatedWidgets = updateUsedWidget({
          item: portlet,
          used: false,
          widgets: widgets
        });
        setWidgets(updatedWidgets);
      };

      Liferay.on('closePortlet', removePortlet);
      return function () {
        Liferay.detach('closePortlet', removePortlet);
      };
    }, [widgets]);
    var tabs = (0, _react.useMemo)(function () {
      return [{
        collections: widgets.map(function (collection) {
          return normalizeCollections(collection);
        }),
        id: 'widgets',
        label: Liferay.Language.get('widgets')
      }, {
        collections: [{
          children: contents.map(normalizeContent),
          collectionId: 'recent-content',
          label: Liferay.Language.get('recent')
        }],
        id: 'content',
        label: Liferay.Language.get('content')
      }];
    }, [contents, widgets]);
    return _react["default"].createElement("div", {
      className: (0, _classnames["default"])('sidebar-body__add-panel', {
        rtl: rtl
      })
    }, _react["default"].createElement(AddPanelContextProvider, {
      value: {
        addContentsURLs: addContentsURLs,
        contents: contents,
        displayGrid: displayGrid,
        getContentsURL: getContentsURL,
        namespace: namespace,
        plid: plid,
        portletNamespace: portletNamespace,
        setDisplayGrid: setDisplayGrid,
        setWidgets: setWidgets,
        widgets: widgets
      }
    }, _react["default"].createElement(_reactDnd.DndProvider, {
      backend: _reactDndHtml5Backend.HTML5Backend
    }, _react["default"].createElement(_DragPreview["default"], {
      rtl: rtl
    }), _react["default"].createElement(_DragAndDrop["default"], null), _react["default"].createElement(_TabsPanel["default"], {
      tabs: tabs
    }))));
  };

  var updateUsedPortlet = function updateUsedPortlet(_ref2) {
    var item = _ref2.item,
        portlet = _ref2.portlet,
        used = _ref2.used;

    if (portlet.portletId === item.itemId && !portlet.instanceable) {
      var _portlet$portletItems;

      portlet.used = used;

      if ((_portlet$portletItems = portlet.portletItems) === null || _portlet$portletItems === void 0 ? void 0 : _portlet$portletItems.length) {
        portlet.portletItems.map(function (portletItem) {
          portletItem.used = used;
        });
      }
    }
  };

  var updateUsedCategoryPortlet = function updateUsedCategoryPortlet(_ref3) {
    var _category$portlets, _category$categories;

    var category = _ref3.category,
        item = _ref3.item,
        used = _ref3.used;

    if ((_category$portlets = category.portlets) === null || _category$portlets === void 0 ? void 0 : _category$portlets.length) {
      category.portlets.map(function (portlet) {
        updateUsedPortlet({
          item: item,
          portlet: portlet,
          used: used
        });
      });
    }

    return ((_category$categories = category.categories) === null || _category$categories === void 0 ? void 0 : _category$categories.length) ? _objectSpread({}, category, {
      categories: category.categories.map(function (category) {
        return updateUsedCategoryPortlet({
          category: category,
          item: item,
          used: used
        });
      })
    }) : category;
  };

  var updateUsedWidget = function updateUsedWidget(_ref4) {
    var item = _ref4.item,
        _ref4$used = _ref4.used,
        used = _ref4$used === void 0 ? true : _ref4$used,
        widgets = _ref4.widgets;
    return widgets.map(function (collection) {
      updateUsedCategoryPortlet({
        category: collection,
        item: item,
        used: used
      });
      return _objectSpread({}, collection, {
        portlets: collection.portlets.map(function (portlet) {
          updateUsedPortlet({
            item: item,
            portlet: portlet,
            used: used
          });
          return _objectSpread({}, portlet);
        })
      });
    });
  };

  exports.updateUsedWidget = updateUsedWidget;

  var normalizeCollections = function normalizeCollections(collection) {
    var _collection$categorie;

    var normalizedElement = {
      children: collection.portlets.map(normalizeWidget),
      collectionId: collection.path,
      label: collection.title
    };

    if ((_collection$categorie = collection.categories) === null || _collection$categorie === void 0 ? void 0 : _collection$categorie.length) {
      normalizedElement.collections = collection.categories.map(normalizeCollections);
    }

    return normalizedElement;
  };

  var normalizeWidget = function normalizeWidget(widget) {
    var _widget$portletItems;

    return {
      data: {
        instanceable: widget.instanceable,
        portletId: widget.portletId,
        portletItemId: widget.portletItemId || null,
        used: widget.used
      },
      disabled: !widget.instanceable && widget.used,
      icon: widget.instanceable ? 'cards2' : 'square-hole',
      itemId: widget.portletId,
      label: widget.title,
      portletItems: ((_widget$portletItems = widget.portletItems) === null || _widget$portletItems === void 0 ? void 0 : _widget$portletItems.length) ? widget.portletItems.map(normalizeWidget) : null,
      type: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.widget
    };
  };

  var normalizeContent = function normalizeContent(content) {
    return {
      category: content.type,
      data: {
        className: content.className,
        classPK: content.classPK,
        draggable: content.draggable,
        instanceable: content.instanceable,
        portletId: content.portletId
      },
      disabled: !content.draggable,
      icon: content.icon,
      itemId: "".concat(content.portletId, "_").concat(content.classPK),
      label: content.title,
      type: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.content
    };
  };

  exports.normalizeContent = normalizeContent;
  var _default = AddPanel;
  exports["default"] = _default;
  //# sourceMappingURL=AddPanel.js.map
});
//# sourceMappingURL=AddPanel.js.map