Liferay.Loader.define("product-navigation-control-menu-web@4.0.62/js/LayoutFinder.es", ['module', 'exports', 'require', 'frontend-js-web/liferay/compat/modal/Modal.es', 'frontend-js-web', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './LayoutFinder.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.LayoutFinder = void 0;

  require("frontend-js-web/liferay/compat/modal/Modal.es");

  var _frontendJsWeb = require("frontend-js-web");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _LayoutFinder = _interopRequireDefault(require("./LayoutFinder.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * LayoutFinder
   * @review
   */
  var LayoutFinder = /*#__PURE__*/function (_Component) {
    _inherits(LayoutFinder, _Component);

    function LayoutFinder() {
      _classCallCheck(this, LayoutFinder);

      return _possibleConstructorReturn(this, _getPrototypeOf(LayoutFinder).apply(this, arguments));
    }

    _createClass(LayoutFinder, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        this._handleDocumentClick = this._handleDocumentClick.bind(this);
        this._documentClickHandler = _metalDom["default"].on(document, 'click', this._handleDocumentClick);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        if (this._documentClickHandler) {
          this._documentClickHandler.removeListener();

          this._documentClickHandler = null;
        }
      }
      /**
       * Handles close button click in order to hide the dialog
       * @private
       * @review
       */

    }, {
      key: "_handleCloseDialogClick",
      value: function _handleCloseDialogClick() {
        this.layouts = [];
        this.totalCount = 0;
        this._keywords = '';
        this._showFinder = false;
      }
      /**
       * Handles document click in order to hide the dialog
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleDocumentClick",
      value: function _handleDocumentClick(event) {
        if (this._showFinder && this.refs.dialog && !this.refs.dialog.contains(event.target)) {
          this._handleCloseDialogClick();
        }
      }
      /**
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleFormSubmit",
      value: function _handleFormSubmit(event) {
        event.preventDefault();
        event.stopPropagation();
      }
      /**
       * Handles keyUp event on the filter input to filter the layouts
       * @param {!KeyboardEvent} event
       * @private
       * @preview
       */

    }, {
      key: "_handleSearchInputKeyUp",
      value: function _handleSearchInputKeyUp(event) {
        var keywords = event.delegateTarget.value;

        if (keywords.length < 2) {
          this.layouts = [];
          this.totalCount = 0;
          this._keywords = '';
        } else if (keywords !== this._keywords) {
          this._keywords = keywords;

          this._updatePageResults(this._keywords);
        }
      }
      /**
       * Update page results with the given keywords
       * @param {string} keywords
       * @private
       * @return {Promise}
       * @review
       */

    }, {
      key: "_updatePageResults",
      value: function _updatePageResults(keywords) {
        var _this = this;

        var promise = Promise.resolve();

        if (!this._loading && keywords.length >= 2) {
          this._loading = true;
          var formData = new FormData();
          formData.append("".concat(this.namespace, "keywords"), keywords);
          promise = (0, _frontendJsWeb.fetch)(this.findLayoutsURL, {
            body: formData,
            method: 'post'
          }).then(function (response) {
            return response.ok ? response.json() : {
              layouts: [],
              totalCount: 0
            };
          }).then(function (response) {
            _this.layouts = response.layouts;
            _this.totalCount = response.totalCount;
            _this._loading = false;
            _this._viewInPageAdministrationURL = "".concat(_this.administrationPortletURL, "&").concat(_this.administrationPortletNamespace, "keywords=").concat(keywords);

            if (_this._showFinder && keywords !== _this._keywords) {
              _this._updatePageResults(_this._keywords);
            }
          });
        }

        return promise;
      }
      /**
       * Toggles layout finder dialog visivility
       * @private
       * @review
       */

    }, {
      key: "_toggleDialog",
      value: function _toggleDialog() {
        this._showFinder = !this._showFinder;
      }
    }]);

    return LayoutFinder;
  }(_metalComponent["default"]);
  /**
   * State definition
   * @review
   * @static
   * @type {!Object}
   */

  exports.LayoutFinder = LayoutFinder;
  LayoutFinder.STATE = {
    /**
     * Document click handler
     * @default null
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {Object}
     */
    _documentClickHandler: _metalState.Config.object().internal().value(null),

    /**
     * Keywords to find layouts with
     * @default ''
     * @instance
     * @memberOf LayoutFinder
     * @private
     * @review
     * @type {string}
     */
    _keywords: _metalState.Config.string().value(''),

    /**
     * True when it's loading page results
     * @default false
     * @instance
     * @memberOf LayoutFinder
     * @private
     * @review
     * @type {boolean}
     */
    _loading: _metalState.Config.bool().value(false),

    /**
     * Show layout finder dialog
     * @default false
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {boolean}
     */
    _showFinder: _metalState.Config.bool().value(false),

    /**
     * URL to access Pages Administration portlet with keywords parameter
     * @default undefined
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {string}
     */
    _viewInPageAdministrationURL: _metalState.Config.string(),

    /**
     * Namespace for Pages Administration portlet
     * @default undefined
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {!string}
     */
    administrationPortletNamespace: _metalState.Config.string().required(),

    /**
     * URL to access Pages Administration portlet
     * @default undefined
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {!string}
     */
    administrationPortletURL: _metalState.Config.string().required(),

    /**
     * URL to find layouts by keywords
     * @default undefined
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {!string}
     */
    findLayoutsURL: _metalState.Config.string().required(),

    /**
     * Layouts found by current keywords
     * @default []
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {!Array}
     */
    layouts: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      name: _metalState.Config.string().required(),
      url: _metalState.Config.string().required()
    })).required(),

    /**
     * Current portlet max items
     * @default undefined
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {number}
     */
    maxItems: _metalState.Config.number().value(10),

    /**
     * Current portlet namespace
     * @default undefined
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {!string}
     */
    namespace: _metalState.Config.string().required(),

    /**
     * Path of the available icons
     * @default undefined
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Total count of layouts found
     * @default 0
     * @instance
     * @memberOf LayoutFinder
     * @review
     * @type {number}
     */
    totalCount: _metalState.Config.number().value(0)
  };

  _metalSoy["default"].register(LayoutFinder, _LayoutFinder["default"]);

  var _default = LayoutFinder;
  exports["default"] = _default;
  //# sourceMappingURL=LayoutFinder.es.js.map
});
//# sourceMappingURL=LayoutFinder.es.js.map