/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.control.menu.web.internal.util;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.model.impl.LayoutTypeControllerImpl;
import javax.servlet.http.HttpServletRequest;

public class ProductNavigationControlMenuUtil {
    public static boolean isEditEnabled(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isStateMaximized()) {
            return false;
        }
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypePortlet()) {
            return false;
        }
        if (StagingUtil.isIncomplete((Layout)layout)) {
            return false;
        }
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        LayoutTypeController layoutTypeController = layoutTypePortlet.getLayoutTypeController();
        if (layoutTypeController.isFullPageDisplayable()) {
            return false;
        }
        if (!(layoutTypeController instanceof LayoutTypeControllerImpl)) {
            return false;
        }
        if (!ProductNavigationControlMenuUtil._hasAddContentOrApplicationPermission(themeDisplay)) {
            return false;
        }
        return ProductNavigationControlMenuUtil._hasUpdateLayoutPermission(themeDisplay) || ProductNavigationControlMenuUtil._hasCustomizePermission(themeDisplay);
    }

    private static boolean _hasAddContentOrApplicationPermission(ThemeDisplay themeDisplay) {
        Layout layout = themeDisplay.getLayout();
        return !layout.isLayoutPrototypeLinkActive();
    }

    private static boolean _hasCustomizePermission(ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        if (!layout.isTypePortlet() || layoutTypePortlet == null) {
            return false;
        }
        if (!layoutTypePortlet.isCustomizable() || !layoutTypePortlet.isCustomizedView()) {
            return false;
        }
        return LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"CUSTOMIZE");
    }

    private static boolean _hasUpdateLayoutPermission(ThemeDisplay themeDisplay) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)"UPDATE");
    }
}

