/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.control.menu.web.internal.portlet.action;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_product_navigation_control_menu_web_portlet_ProductNavigationControlMenuPortlet", "mvc.command.name=/control_menu/find_layouts"}, service={MVCResourceCommand.class})
public class FindLayoutsMVCResourceCommand
extends BaseMVCResourceCommand {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String keywords = ParamUtil.getString((PortletRequest)resourceRequest, (String)"keywords");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)resourceResponse);
        httpServletResponse.setContentType("application/json");
        if (Validator.isNull((String)keywords)) {
            jsonObject.put("layouts", JSONFactoryUtil.createJSONArray()).put("totalCount", 0);
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)jsonObject.toString());
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List layouts = this._layoutLocalService.getLayouts(themeDisplay.getScopeGroupId(), keywords, new String[]{"content", "embedded", "link_to_layout", "full_page_application", "panel", "portlet", "url"}, 0, 10, null);
        for (Layout layout : layouts) {
            StringBundler sb = new StringBundler(5);
            sb.append(layout.getName(themeDisplay.getLocale()));
            sb.append(" ");
            sb.append("(");
            if (layout.isPrivateLayout()) {
                sb.append(LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"private"));
            } else {
                sb.append(LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"public"));
            }
            sb.append(")");
            JSONObject layoutJSONObject = JSONUtil.put((String)"name", (Object)sb.toString()).put("url", this._portal.getLayoutFullURL(layout, themeDisplay));
            jsonArray.put(layoutJSONObject);
        }
        jsonObject.put("layouts", jsonArray);
        int totalCount = this._layoutLocalService.getLayoutsCount(themeDisplay.getScopeGroupId(), keywords, new String[]{"content", "embedded", "link_to_layout", "full_page_application", "panel", "portlet", "url"});
        jsonObject.put("totalCount", totalCount);
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)jsonObject.toString());
    }
}

