/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.control.menu.internal.util;

import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuCategory;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.util.ProductNavigationControlMenuEntryRegistry;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ProductNavigationControlMenuEntryRegistry.class})
public class ProductNavigationControlMenuEntryRegistryImpl
implements ProductNavigationControlMenuEntryRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ProductNavigationControlMenuEntryRegistryImpl.class);
    private ServiceTrackerMap<String, List<ProductNavigationControlMenuEntry>> _serviceTrackerMap;

    public List<ProductNavigationControlMenuEntry> getProductNavigationControlMenuEntries(ProductNavigationControlMenuCategory productNavigationControlMenuCategory) {
        List productNavigationControlMenuEntries = (List)this._serviceTrackerMap.getService((Object)productNavigationControlMenuCategory.getKey());
        if (productNavigationControlMenuEntries == null) {
            return Collections.emptyList();
        }
        return productNavigationControlMenuEntries;
    }

    public List<ProductNavigationControlMenuEntry> getProductNavigationControlMenuEntries(ProductNavigationControlMenuCategory productNavigationControlMenuCategory, HttpServletRequest httpServletRequest) {
        List<ProductNavigationControlMenuEntry> productNavigationControlMenuEntries = this.getProductNavigationControlMenuEntries(productNavigationControlMenuCategory);
        if (productNavigationControlMenuEntries.isEmpty()) {
            return productNavigationControlMenuEntries;
        }
        return ListUtil.filter(productNavigationControlMenuEntries, productNavigationControlMenuEntry -> {
            try {
                return productNavigationControlMenuEntry.isShow(httpServletRequest);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return false;
            }
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ProductNavigationControlMenuEntry.class, null, (ServiceReferenceMapper)new PropertyServiceReferenceMapper("product.navigation.control.menu.category.key"), Collections.reverseOrder(new PropertyServiceReferenceComparator("product.navigation.control.menu.entry.order")));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

