/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.control.menu.internal.util;

import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuCategory;
import com.liferay.product.navigation.control.menu.util.ProductNavigationControlMenuCategoryRegistry;
import com.liferay.product.navigation.control.menu.util.ProductNavigationControlMenuEntryRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ProductNavigationControlMenuCategoryRegistry.class})
public class ProductNavigationControlMenuCategoryRegistryImpl
implements ProductNavigationControlMenuCategoryRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ProductNavigationControlMenuCategoryRegistryImpl.class);
    @Reference
    private ProductNavigationControlMenuEntryRegistry _productNavigationControlMenuEntryRegistry;
    private ServiceTrackerMap<String, List<ProductNavigationControlMenuCategory>> _serviceTrackerMap;

    public List<ProductNavigationControlMenuCategory> getProductNavigationControlMenuCategories(String productNavigationControlMenuCategoryKey) {
        List productNavigationControlMenuCategories = (List)this._serviceTrackerMap.getService((Object)productNavigationControlMenuCategoryKey);
        if (productNavigationControlMenuCategories == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ProductNavigationControlMenuCategory>(productNavigationControlMenuCategories);
    }

    public List<ProductNavigationControlMenuCategory> getProductNavigationControlMenuCategories(String productNavigationControlMenuCategoryKey, HttpServletRequest httpServletRequest) {
        List<ProductNavigationControlMenuCategory> productNavigationControlMenuCategories = this.getProductNavigationControlMenuCategories(productNavigationControlMenuCategoryKey);
        if (productNavigationControlMenuCategories.isEmpty()) {
            return productNavigationControlMenuCategories;
        }
        return ListUtil.filter(productNavigationControlMenuCategories, productNavigationControlMenuCategory -> {
            try {
                if (!productNavigationControlMenuCategory.hasAccessPermission(httpServletRequest)) {
                    return false;
                }
                List productNavigationControlMenuEntries = this._productNavigationControlMenuEntryRegistry.getProductNavigationControlMenuEntries(productNavigationControlMenuCategory, httpServletRequest);
                return !productNavigationControlMenuEntries.isEmpty();
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return false;
            }
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ProductNavigationControlMenuCategory.class, null, (ServiceReferenceMapper)new PropertyServiceReferenceMapper("product.navigation.control.menu.category.key"), Collections.reverseOrder(new PropertyServiceReferenceComparator("product.navigation.control.menu.category.order")));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

