/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.control.menu.internal.manager;

import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.product.navigation.control.menu.manager.ProductNavigationControlMenuManager;
import com.liferay.site.configuration.MenuAccessConfiguration;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ProductNavigationControlMenuManager.class})
public class ProductNavigationControlMenuManagerImpl
implements ProductNavigationControlMenuManager {
    private static final Log _log = LogFactoryUtil.getLog(ProductNavigationControlMenuManagerImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;

    public boolean isShowControlMenu(HttpServletRequest httpServletRequest) {
        if (Objects.equals("preview", ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_l_mode", (String)"view")) || this._isLockedLayoutView(httpServletRequest) || this._isGuestUser(httpServletRequest)) {
            return false;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = themeDisplay.getScopeGroup();
        Layout layout = themeDisplay.getLayout();
        if (!group.isSite() || layout.isDraftLayout() || layout.isTypeControlPanel()) {
            return true;
        }
        try {
            MenuAccessConfiguration menuAccessConfiguration = (MenuAccessConfiguration)this._configurationProvider.getGroupConfiguration(MenuAccessConfiguration.class, group.getGroupId());
            if (menuAccessConfiguration != null && menuAccessConfiguration.showControlMenuByRole()) {
                Object[] accessToControlMenuRoleIds = menuAccessConfiguration.accessToControlMenuRoleIds();
                User user = themeDisplay.getUser();
                for (Role role : user.getAllRoles()) {
                    if (!Objects.equals(role.getName(), "Administrator") && !Objects.equals(role.getRoleId(), "Site Administrator") && !ArrayUtil.contains((Object[])accessToControlMenuRoleIds, (Object)String.valueOf(role.getRoleId()))) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return true;
    }

    private boolean _isGuestUser(HttpServletRequest httpServletRequest) {
        block4: {
            try {
                User user = this._portal.getUser(httpServletRequest);
                if (user == null) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    user = themeDisplay.getUser();
                }
                if (user == null || user.isGuestUser()) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)"Unable to determine if user is guest user", (Throwable)exception);
            }
        }
        return false;
    }

    private boolean _isLockedLayoutView(HttpServletRequest httpServletRequest) {
        String mvcRenderCommandName = this._portal.getPortletNamespace("com_liferay_layout_admin_web_portlet_GroupPagesPortlet") + "mvcRenderCommandName";
        return Objects.equals(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)mvcRenderCommandName), "/layout_admin/locked_layout");
    }
}

