/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.control.menu.util;

import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuCategory;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.util.ProductNavigationControlMenuEntryServiceReferenceMapper;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={ProductNavigationControlMenuEntryRegistry.class})
public class ProductNavigationControlMenuEntryRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ProductNavigationControlMenuEntryRegistry.class);
    private ServiceTrackerMap<String, List<ProductNavigationControlMenuEntry>> _serviceTrackerMap;

    public List<ProductNavigationControlMenuEntry> getProductNavigationControlMenuEntries(ProductNavigationControlMenuCategory productNavigationControlMenuCategory) {
        List productNavigationControlMenuEntries = (List)this._serviceTrackerMap.getService((Object)productNavigationControlMenuCategory.getKey());
        if (productNavigationControlMenuEntries == null) {
            return Collections.emptyList();
        }
        return productNavigationControlMenuEntries;
    }

    public List<ProductNavigationControlMenuEntry> getProductNavigationControlMenuEntries(ProductNavigationControlMenuCategory productNavigationControlMenuCategory, final HttpServletRequest request) {
        List<ProductNavigationControlMenuEntry> productNavigationControlMenuEntries = this.getProductNavigationControlMenuEntries(productNavigationControlMenuCategory);
        if (productNavigationControlMenuEntries.isEmpty()) {
            return productNavigationControlMenuEntries;
        }
        return ListUtil.filter(productNavigationControlMenuEntries, (PredicateFilter)new PredicateFilter<ProductNavigationControlMenuEntry>(){

            public boolean filter(ProductNavigationControlMenuEntry productNavigationControlMenuEntry) {
                try {
                    return productNavigationControlMenuEntry.isShow(request);
                }
                catch (PortalException pe) {
                    _log.error((Object)pe, (Throwable)pe);
                    return false;
                }
            }
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ProductNavigationControlMenuEntry.class, (String)"(product.navigation.control.menu.category.key=*)", (ServiceReferenceMapper)new ProductNavigationControlMenuEntryServiceReferenceMapper(), Collections.reverseOrder(new PropertyServiceReferenceComparator("product.navigation.control.menu.entry.order")));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

