/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.control.menu.util;

import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuCategory;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.util.ProductNavigationControlMenuCategoryServiceReferenceMapper;
import com.liferay.product.navigation.control.menu.util.ProductNavigationControlMenuEntryRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ProductNavigationControlMenuCategoryRegistry.class})
public class ProductNavigationControlMenuCategoryRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ProductNavigationControlMenuCategoryRegistry.class);
    private ServiceTrackerMap<String, List<ProductNavigationControlMenuCategory>> _productNavigationControlMenuCategoryServiceTrackerMap;
    private ProductNavigationControlMenuEntryRegistry _productNavigationControlMenuEntryRegistry;

    public List<ProductNavigationControlMenuCategory> getProductNavigationControlMenuCategories(String productNavigationControlMenuCategoryKey) {
        List productNavigationControlMenuCategories = (List)this._productNavigationControlMenuCategoryServiceTrackerMap.getService((Object)productNavigationControlMenuCategoryKey);
        if (productNavigationControlMenuCategories == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ProductNavigationControlMenuCategory>(productNavigationControlMenuCategories);
    }

    public List<ProductNavigationControlMenuCategory> getProductNavigationControlMenuCategories(String productNavigationControlMenuCategoryKey, final HttpServletRequest request) {
        List<ProductNavigationControlMenuCategory> productNavigationControlMenuCategories = this.getProductNavigationControlMenuCategories(productNavigationControlMenuCategoryKey);
        if (productNavigationControlMenuCategories.isEmpty()) {
            return productNavigationControlMenuCategories;
        }
        return ListUtil.filter(productNavigationControlMenuCategories, (PredicateFilter)new PredicateFilter<ProductNavigationControlMenuCategory>(){

            public boolean filter(ProductNavigationControlMenuCategory productNavigationControlMenuCategory) {
                try {
                    if (!productNavigationControlMenuCategory.hasAccessPermission(request)) {
                        return false;
                    }
                    List<ProductNavigationControlMenuEntry> productNavigationControlMenuEntries = ProductNavigationControlMenuCategoryRegistry.this._productNavigationControlMenuEntryRegistry.getProductNavigationControlMenuEntries(productNavigationControlMenuCategory, request);
                    return !productNavigationControlMenuEntries.isEmpty();
                }
                catch (PortalException pe) {
                    _log.error((Object)pe, (Throwable)pe);
                    return false;
                }
            }
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._productNavigationControlMenuCategoryServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ProductNavigationControlMenuCategory.class, (String)"(product.navigation.control.menu.category.key=*)", (ServiceReferenceMapper)new ProductNavigationControlMenuCategoryServiceReferenceMapper(), Collections.reverseOrder(new PropertyServiceReferenceComparator("service.ranking")));
    }

    @Deactivate
    protected void deactivate() {
        this._productNavigationControlMenuCategoryServiceTrackerMap.close();
    }

    @Reference(unbind="-")
    protected void setProductNavigationControlMenuEntryRegistry(ProductNavigationControlMenuEntryRegistry productNavigationControlMenuEntryRegistry) {
        this._productNavigationControlMenuEntryRegistry = productNavigationControlMenuEntryRegistry;
    }
}

