/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.display.template.web.internal.webdav;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.webdav.DDMWebDAV;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_web_portlet_PortletDisplayTemplatePortlet", "webdav.storage.token=application_display_template"}, service={WebDAVStorage.class})
public class ApplicationDisplayTemplateWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private DDMWebDAV _ddmWebDAV;

    public int deleteResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this._ddmWebDAV.deleteResource(webDAVRequest, this.getRootPath(), this.getToken(), 0L);
    }

    public Resource getResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this._ddmWebDAV.getResource(webDAVRequest, this.getRootPath(), this.getToken(), 0L);
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            String[] pathArray = webDAVRequest.getPathArray();
            if (pathArray.length == 2) {
                return this.getFolders(webDAVRequest);
            }
            if (pathArray.length == 3) {
                return this.getTemplates(webDAVRequest);
            }
            return new ArrayList<Resource>();
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int putResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this._ddmWebDAV.putResource(webDAVRequest, this.getRootPath(), this.getToken(), 0L);
    }

    protected List<Resource> getFolders(WebDAVRequest webDAVRequest) throws Exception {
        return ListUtil.toList((Object)this._ddmWebDAV.toResource(webDAVRequest, "Templates", this.getRootPath(), true));
    }

    protected List<Resource> getTemplates(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List ddmTemplates = this._ddmTemplateLocalService.getTemplatesByClassPK(webDAVRequest.getGroupId(), 0L);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            Resource resource = this._ddmWebDAV.toResource(webDAVRequest, ddmTemplate, this.getRootPath(), true);
            resources.add(resource);
        }
        return resources;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMWebDAV(DDMWebDAV ddmWebDAV) {
        this._ddmWebDAV = ddmWebDAV;
    }
}

