/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.display.template.web.internal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_dynamic_data_mapping_web_portlet_PortletDisplayTemplatePortlet"}, service={PortletDataHandler.class})
public class PortletDisplayTemplatePortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "portlet_display_template";
    public static final String SCHEMA_VERSION = "1.0.0";
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private Portal _portal;
    private StagedModelType[] _stagedModelTypes;
    @Reference
    private Staging _staging;

    public StagedModelType[] getDeletionSystemEventStagedModelTypes() {
        return this.getStagedModelTypes();
    }

    public long getExportModelCount(ManifestSummary manifestSummary) {
        long totalModelCount = -1L;
        for (StagedModelType stagedModelType : this.getStagedModelTypes()) {
            long modelCount = manifestSummary.getModelAdditionCount(stagedModelType);
            if (modelCount == -1L) continue;
            if (totalModelCount == -1L) {
                totalModelCount = modelCount;
                continue;
            }
            totalModelCount += modelCount;
        }
        return totalModelCount;
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    @Activate
    protected void activate() {
        this.setExportControls(this._getPortletDataHandlerControls());
        this.setStagingControls(this.getExportControls());
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        long[] classNameIds = TemplateHandlerRegistryUtil.getClassNameIds();
        ActionableDynamicQuery actionableDynamicQuery = this.getDDMTemplateActionableDynamicQuery(portletDataContext, ArrayUtil.toArray((long[])classNameIds), new StagedModelType(this._portal.getClassNameId(DDMTemplate.class), -1L));
        actionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        Element ddmTemplatesElement = portletDataContext.getImportDataGroupElement(DDMTemplate.class);
        List ddmTemplateElements = ddmTemplatesElement.elements();
        for (Element ddmTemplateElement : ddmTemplateElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmTemplateElement);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, this.getStagedModelTypes());
            return;
        }
        for (StagedModelType stagedModelType : this.getStagedModelTypes()) {
            ActionableDynamicQuery actionableDynamicQuery = this.getDDMTemplateActionableDynamicQuery(portletDataContext, new Long[]{stagedModelType.getReferrerClassNameId()}, stagedModelType);
            actionableDynamicQuery.performCount();
        }
    }

    protected ActionableDynamicQuery getDDMTemplateActionableDynamicQuery(PortletDataContext portletDataContext, Long[] classNameIds, StagedModelType stagedModelType) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddmTemplateLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.in((Object[])classNameIds));
            Property classPKProperty = PropertyFactoryUtil.forName((String)"classPK");
            dynamicQuery.add(classPKProperty.eq((Object)0L));
            Property typeProperty = PropertyFactoryUtil.forName((String)"type");
            dynamicQuery.add(typeProperty.eq((Object)"display"));
        });
        exportActionableDynamicQuery.setStagedModelType(stagedModelType);
        return exportActionableDynamicQuery;
    }

    protected StagedModelType[] getStagedModelTypes() {
        if (this._stagedModelTypes != null) {
            return this._stagedModelTypes;
        }
        ArrayList<StagedModelType> stagedModelTypes = new ArrayList<StagedModelType>();
        long ddmTemplateClassNameId = this._portal.getClassNameId(DDMTemplate.class);
        for (long classNameId : TemplateHandlerRegistryUtil.getClassNameIds()) {
            stagedModelTypes.add(new StagedModelType(ddmTemplateClassNameId, classNameId));
        }
        this._stagedModelTypes = stagedModelTypes.toArray(new StagedModelType[0]);
        return this._stagedModelTypes;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private PortletDataHandlerControl[] _getPortletDataHandlerControls() {
        ArrayList<PortletDataHandlerBoolean> portletDataHandlerControls = new ArrayList<PortletDataHandlerBoolean>();
        portletDataHandlerControls.add(new PortletDataHandlerBoolean(NAMESPACE, "application-display-templates", true, true));
        for (TemplateHandler templateHandler : TemplateHandlerRegistryUtil.getTemplateHandlers()) {
            ClassName className = this._classNameLocalService.fetchClassName(templateHandler.getClassName());
            if (className == null) continue;
            portletDataHandlerControls.add(new PortletDataHandlerBoolean(NAMESPACE, templateHandler.getName(LocaleUtil.getSiteDefault()), true, false, null, DDMTemplate.class.getName(), className.getValue()));
        }
        return portletDataHandlerControls.toArray(new PortletDataHandlerControl[0]);
    }
}

