"use strict";

Liferay.Loader.define("portlet-configuration-css-web@4.0.9/js/ToggleDisableInputs.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-soy', './ToggleDisableInputs.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _ToggleDisableInputs = _interopRequireDefault(require("./ToggleDisableInputs.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * ToggleDisableInputs
   *
   * This class creates a switch button that enable/disable different inputs
   * based on its state.
   */
  var ToggleDisableInputs =
  /*#__PURE__*/
  function (_Component) {
    _inherits(ToggleDisableInputs, _Component);

    function ToggleDisableInputs() {
      _classCallCheck(this, ToggleDisableInputs);

      return _possibleConstructorReturn(this, _getPrototypeOf(ToggleDisableInputs).apply(this, arguments));
    }

    _createClass(ToggleDisableInputs, [{
      key: "toggleSwitch",

      /**
       * Toggles the state of the switch
       */
      value: function toggleSwitch() {
        this.checked = !this.checked;
        this.disableInputs_();
      }
      /**
       * Disables the inputs based on switch state and disableOnChecked logic
       */

    }, {
      key: "disableInputs_",
      value: function disableInputs_() {
        var checked = this.checked,
            disableOnChecked = this.disableOnChecked,
            inputSelector = this.inputSelector;
        var inputs = document.querySelectorAll(inputSelector);

        for (var i = 0; i < inputs.length; i++) {
          var input = inputs[i];
          input.disabled = disableOnChecked ? checked : !checked;
        }
      }
    }]);

    return ToggleDisableInputs;
  }(_metalComponent.default);
  /**
   * State definition.
   * @type {!Object}
   * @static
   */

  ToggleDisableInputs.STATE = {
    /**
     * Switch state
     * @type {Boolean}
     */
    checked: {
      validator: _metal.default.isBoolean,
      value: false
    },

    /**
     * Flag to specify the logic for disabling inputs based on switch state
     * @type {Boolean}
     */
    disableOnChecked: {
      validator: _metal.default.isBoolean,
      value: true
    },

    /**
     * CSS Selector for the inputs to enable/disable
     * @type {String}
     */
    inputSelector: {
      validator: _metal.default.isString
    },

    /**
     * Label of the switch
     * @type {String}
     */
    label: {
      validator: _metal.default.isString
    },

    /**
     * Label of the "off" state
     * @type {String}
     */
    labelOff: {
      validator: _metal.default.isString
    },

    /**
     * Label of the "on" state
     * @type {String}
     */
    labelOn: {
      validator: _metal.default.isString
    }
  };

  _metalSoy.default.register(ToggleDisableInputs, _ToggleDisableInputs.default);

  var _default = ToggleDisableInputs;
  exports.default = _default;
  //# sourceMappingURL=ToggleDisableInputs.es.js.map
});
//# sourceMappingURL=ToggleDisableInputs.es.js.map