/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.configuration.css.web.internal.portlet;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.icon=/icons/portlet_css.png", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.system=true", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Portlet CSS", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_portlet_configuration_css_web_portlet_PortletConfigurationCSSPortlet", "javax.portlet.resource-bundle=content.Language"}, service={Portlet.class})
public class PortletConfigurationCSSPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(PortletConfigurationCSSPortlet.class);
    @Reference
    private Portal _portal;

    public void updateLookAndFeel(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String portletId;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)(portletId = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletId")), (String)"CONFIGURATION")) {
            return;
        }
        PortletPreferences portletSetup = themeDisplay.getStrictLayoutPortletSetup(layout, portletId);
        String css = this.getCSS(actionRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating css " + css));
        }
        String portletDecoratorId = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletDecoratorId");
        Map customTitleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"customTitle");
        boolean useCustomTitle = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"useCustomTitle");
        Set locales = LanguageUtil.getAvailableLocales((long)themeDisplay.getSiteGroupId());
        for (Locale locale : locales) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String title = null;
            if (customTitleMap.containsKey(locale)) {
                title = (String)customTitleMap.get(locale);
            }
            String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
            String defaultPortletTitle = this._portal.getPortletTitle(rootPortletId, languageId);
            if (title != null && !Objects.equals(defaultPortletTitle, title)) {
                portletSetup.setValue("portletSetupTitle_" + languageId, title);
                continue;
            }
            portletSetup.reset("portletSetupTitle_" + languageId);
        }
        portletSetup.setValue("portletSetupUseCustomTitle", String.valueOf(useCustomTitle));
        if (Validator.isNotNull((String)portletDecoratorId)) {
            portletSetup.setValue("portletSetupPortletDecoratorId", portletDecoratorId);
        } else {
            portletSetup.reset("portletSetupPortletDecoratorId");
        }
        portletSetup.setValue("portletSetupCss", css);
        portletSetup.store();
        SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".refreshPortlet"), (Object)portletId);
    }

    protected JSONObject getAdvancedDataJSONObject(ActionRequest actionRequest) {
        String customCSS = ParamUtil.getString((PortletRequest)actionRequest, (String)"customCSS");
        JSONObject advancedDataJSONObject = JSONUtil.put((String)"customCSS", (Object)customCSS);
        String customCSSClassName = ParamUtil.getString((PortletRequest)actionRequest, (String)"customCSSClassName");
        advancedDataJSONObject.put("customCSSClassName", customCSSClassName);
        return advancedDataJSONObject;
    }

    protected JSONObject getBgDataJSONObject(ActionRequest actionRequest) {
        String backgroundColor = ParamUtil.getString((PortletRequest)actionRequest, (String)"backgroundColor");
        JSONObject bgDataJSONObject = JSONUtil.put((String)"backgroundColor", (Object)backgroundColor).put("backgroundImage", "");
        JSONObject backgroundPositionLeftJSONObject = JSONUtil.put((String)"unit", (Object)"").put("value", "");
        JSONObject backgroundPositionJSONObject = JSONUtil.put((String)"left", (Object)backgroundPositionLeftJSONObject);
        JSONObject backgroundPositionTopJSONObject = JSONUtil.put((String)"unit", (Object)"").put("value", "");
        backgroundPositionJSONObject.put("top", backgroundPositionTopJSONObject);
        bgDataJSONObject.put("backgroundPosition", backgroundPositionJSONObject).put("backgroundRepeat", "").put("useBgImage", false);
        return bgDataJSONObject;
    }

    protected JSONObject getBorderDataJSONObject(ActionRequest actionRequest) {
        String borderColorBottom = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderColorBottom");
        JSONObject borderColorJSONObject = JSONUtil.put((String)"bottom", (Object)borderColorBottom);
        String borderColorLeft = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderColorLeft");
        borderColorJSONObject.put("left", borderColorLeft);
        String borderColorRight = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderColorRight");
        borderColorJSONObject.put("right", borderColorRight);
        boolean useForAllColor = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"useForAllColor");
        borderColorJSONObject.put("sameForAll", useForAllColor);
        String borderColorTop = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderColorTop");
        borderColorJSONObject.put("top", borderColorTop);
        JSONObject borderDataJSONObject = JSONUtil.put((String)"borderColor", (Object)borderColorJSONObject);
        String borderStyleBottom = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderStyleBottom");
        JSONObject borderStyleJSONObject = JSONUtil.put((String)"bottom", (Object)borderStyleBottom);
        String borderStyleLeft = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderStyleLeft");
        borderStyleJSONObject.put("left", borderStyleLeft);
        String borderStyleRight = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderStyleRight");
        borderStyleJSONObject.put("right", borderStyleRight);
        boolean useForAllStyle = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"useForAllStyle");
        borderStyleJSONObject.put("sameForAll", useForAllStyle);
        String borderStyleTop = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderStyleTop");
        borderStyleJSONObject.put("top", borderStyleTop);
        borderDataJSONObject.put("borderStyle", borderStyleJSONObject);
        String borderWidthBottomUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderWidthBottomUnit");
        JSONObject borderWidthBottomJSONObject = JSONUtil.put((String)"unit", (Object)borderWidthBottomUnit);
        String borderWidthBottom = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderWidthBottom");
        borderWidthBottomJSONObject.put("value", borderWidthBottom);
        JSONObject borderWidthJSONObject = JSONUtil.put((String)"bottom", (Object)borderWidthBottomJSONObject);
        String borderWidthLeftUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderWidthLeftUnit");
        JSONObject borderWidthLeftJSONObject = JSONUtil.put((String)"unit", (Object)borderWidthLeftUnit);
        String borderWidthLeft = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderWidthLeft");
        borderWidthLeftJSONObject.put("value", borderWidthLeft);
        borderWidthJSONObject.put("left", borderWidthLeftJSONObject);
        String borderWidthRightUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderWidthRightUnit");
        JSONObject borderWidthRightJSONObject = JSONUtil.put((String)"unit", (Object)borderWidthRightUnit);
        String borderWidthRight = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderWidthRight");
        borderWidthRightJSONObject.put("value", borderWidthRight);
        borderWidthJSONObject.put("right", borderWidthRightJSONObject);
        boolean useForAllWidth = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"useForAllWidth");
        borderWidthJSONObject.put("sameForAll", useForAllWidth);
        String borderWidthTopUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderWidthTopUnit");
        JSONObject borderWidthTopJSONObject = JSONUtil.put((String)"unit", (Object)borderWidthTopUnit);
        String borderWidthTop = ParamUtil.getString((PortletRequest)actionRequest, (String)"borderWidthTop");
        borderWidthTopJSONObject.put("value", borderWidthTop);
        borderWidthJSONObject.put("top", borderWidthTopJSONObject);
        borderDataJSONObject.put("borderWidth", borderWidthJSONObject);
        return borderDataJSONObject;
    }

    protected String getCSS(ActionRequest actionRequest) {
        JSONObject cssJSONObject = JSONUtil.put((String)"advancedData", (Object)this.getAdvancedDataJSONObject(actionRequest)).put("bgData", this.getBgDataJSONObject(actionRequest)).put("borderData", this.getBorderDataJSONObject(actionRequest)).put("spacingData", this.getSpacingDataJSONObject(actionRequest)).put("textData", this.getTextDataJSONObject(actionRequest));
        return cssJSONObject.toString();
    }

    protected JSONObject getSpacingDataJSONObject(ActionRequest actionRequest) {
        String marginBottomUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"marginBottomUnit");
        JSONObject marginBottomJSONObject = JSONUtil.put((String)"unit", (Object)marginBottomUnit);
        String marginBottom = ParamUtil.getString((PortletRequest)actionRequest, (String)"marginBottom");
        marginBottomJSONObject.put("value", marginBottom);
        JSONObject marginJSONObject = JSONUtil.put((String)"bottom", (Object)marginBottomJSONObject);
        String marginLeftUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"marginLeftUnit");
        JSONObject marginLeftJSONObject = JSONUtil.put((String)"unit", (Object)marginLeftUnit);
        String marginLeft = ParamUtil.getString((PortletRequest)actionRequest, (String)"marginLeft");
        marginLeftJSONObject.put("value", marginLeft);
        marginJSONObject.put("left", marginLeftJSONObject);
        String marginRightUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"marginRightUnit");
        JSONObject marginRightJSONObject = JSONUtil.put((String)"unit", (Object)marginRightUnit);
        String marginRight = ParamUtil.getString((PortletRequest)actionRequest, (String)"marginRight");
        marginRightJSONObject.put("value", marginRight);
        marginJSONObject.put("right", marginRightJSONObject);
        boolean useForAllMargin = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"useForAllMargin");
        marginJSONObject.put("sameForAll", useForAllMargin);
        String marginTopUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"marginTopUnit");
        JSONObject marginTopJSONObject = JSONUtil.put((String)"unit", (Object)marginTopUnit);
        String marginTop = ParamUtil.getString((PortletRequest)actionRequest, (String)"marginTop");
        marginTopJSONObject.put("value", marginTop);
        marginJSONObject.put("top", marginTopJSONObject);
        JSONObject spacingDataJSONObject = JSONUtil.put((String)"margin", (Object)marginJSONObject);
        String paddingBottomUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"paddingBottomUnit");
        JSONObject paddingBottomJSONObject = JSONUtil.put((String)"unit", (Object)paddingBottomUnit);
        String paddingBottom = ParamUtil.getString((PortletRequest)actionRequest, (String)"paddingBottom");
        paddingBottomJSONObject.put("value", paddingBottom);
        JSONObject paddingJSONObject = JSONUtil.put((String)"bottom", (Object)paddingBottomJSONObject);
        String paddingLeftUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"paddingLeftUnit");
        JSONObject paddingLeftJSONObject = JSONUtil.put((String)"unit", (Object)paddingLeftUnit);
        String paddingLeft = ParamUtil.getString((PortletRequest)actionRequest, (String)"paddingLeft");
        paddingLeftJSONObject.put("value", paddingLeft);
        paddingJSONObject.put("left", paddingLeftJSONObject);
        String paddingRightUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"paddingRightUnit");
        JSONObject paddingRightJSONObject = JSONUtil.put((String)"unit", (Object)paddingRightUnit);
        String paddingRight = ParamUtil.getString((PortletRequest)actionRequest, (String)"paddingRight");
        paddingRightJSONObject.put("value", paddingRight);
        paddingJSONObject.put("right", paddingRightJSONObject);
        boolean useForAllPadding = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"useForAllPadding");
        paddingJSONObject.put("sameForAll", useForAllPadding);
        String paddingTopUnit = ParamUtil.getString((PortletRequest)actionRequest, (String)"paddingTopUnit");
        JSONObject paddingTopJSONObject = JSONUtil.put((String)"unit", (Object)paddingTopUnit);
        String paddingTop = ParamUtil.getString((PortletRequest)actionRequest, (String)"paddingTop");
        paddingTopJSONObject.put("value", paddingTop);
        paddingJSONObject.put("top", paddingTopJSONObject);
        spacingDataJSONObject.put("padding", paddingJSONObject);
        return spacingDataJSONObject;
    }

    protected JSONObject getTextDataJSONObject(ActionRequest actionRequest) {
        String fontColor = ParamUtil.getString((PortletRequest)actionRequest, (String)"fontColor");
        JSONObject textDataJSONObject = JSONUtil.put((String)"color", (Object)fontColor);
        String fontFamily = ParamUtil.getString((PortletRequest)actionRequest, (String)"fontFamily");
        textDataJSONObject.put("fontFamily", fontFamily);
        String fontSize = ParamUtil.getString((PortletRequest)actionRequest, (String)"fontSize");
        textDataJSONObject.put("fontSize", fontSize);
        boolean fontItalic = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"fontItalic");
        textDataJSONObject.put("fontStyle", fontItalic ? "italic" : "");
        boolean fontBold = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"fontBold");
        textDataJSONObject.put("fontWeight", fontBold ? "bold" : "");
        String letterSpacing = ParamUtil.getString((PortletRequest)actionRequest, (String)"letterSpacing");
        textDataJSONObject.put("letterSpacing", letterSpacing);
        String lineHeight = ParamUtil.getString((PortletRequest)actionRequest, (String)"lineHeight");
        textDataJSONObject.put("lineHeight", lineHeight);
        String textAlign = ParamUtil.getString((PortletRequest)actionRequest, (String)"textAlign");
        textDataJSONObject.put("textAlign", textAlign);
        String textDecoration = ParamUtil.getString((PortletRequest)actionRequest, (String)"textDecoration");
        textDataJSONObject.put("textDecoration", textDecoration);
        String wordSpacing = ParamUtil.getString((PortletRequest)actionRequest, (String)"wordSpacing");
        textDataJSONObject.put("wordSpacing", wordSpacing);
        return textDataJSONObject;
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.portlet.configuration.css.web)(&(release.schema.version>=1.0.0)(!(release.schema.version>=1.1.0))))", unbind="-")
    protected void setRelease(Release release) {
    }
}

