/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.configuration.css.web.internal.display.context;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletDecorator;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.PortletSetupUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PortletConfigurationCSSPortletDisplayContext {
    private DecimalFormat _decimalFormat;
    private String _portletDecoratorId;
    private final String _portletResource;
    private final PortletPreferences _portletSetup;
    private final JSONObject _portletSetupJSONObject;
    private final RenderRequest _renderRequest;
    private Boolean _useCustomTitle;

    public PortletConfigurationCSSPortletDisplayContext(RenderRequest renderRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletResource = ParamUtil.getString((PortletRequest)renderRequest, (String)"portletResource");
        PortletPreferences portletSetup = themeDisplay.getStrictLayoutPortletSetup(themeDisplay.getLayout(), portletResource);
        JSONObject portletSetupJSONObject = PortletSetupUtil.cssToJSONObject((PortletPreferences)portletSetup);
        this._renderRequest = renderRequest;
        this._portletResource = portletResource;
        this._portletSetup = portletSetup;
        this._portletSetupJSONObject = portletSetupJSONObject;
    }

    public String getBackgroundColor() {
        JSONObject bgDataJSONObject = this._portletSetupJSONObject.getJSONObject("bgData");
        if (bgDataJSONObject == null) {
            return "";
        }
        return bgDataJSONObject.getString("backgroundColor");
    }

    public String getBorderProperty(String position, String property) {
        JSONObject borderDataJSONObject = this._portletSetupJSONObject.getJSONObject("borderData");
        if (borderDataJSONObject == null) {
            return "";
        }
        JSONObject borderPropertySONObject = borderDataJSONObject.getJSONObject(property);
        return borderPropertySONObject.getString(position);
    }

    public String getBorderWidthProperty(String position, String property) {
        JSONObject borderDataJSONObject = this._portletSetupJSONObject.getJSONObject("borderData");
        if (borderDataJSONObject == null) {
            return "";
        }
        JSONObject borderWidthSONObject = borderDataJSONObject.getJSONObject("borderWidth");
        JSONObject borderWidthPositionJSONObject = borderWidthSONObject.getJSONObject(position);
        return borderWidthPositionJSONObject.getString(property);
    }

    public String getCustomCSS() {
        JSONObject advancedDataJSONObject = this._portletSetupJSONObject.getJSONObject("advancedData");
        if (advancedDataJSONObject == null) {
            return "";
        }
        return advancedDataJSONObject.getString("customCSS");
    }

    public String getCustomCSSClassName() {
        JSONObject advancedDataJSONObject = this._portletSetupJSONObject.getJSONObject("advancedData");
        if (advancedDataJSONObject == null) {
            return "";
        }
        return advancedDataJSONObject.getString("customCSSClassName");
    }

    public String getCustomTitleXML() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
        HttpSession session = httpServletRequest.getSession();
        ServletContext servletContext = session.getServletContext();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)this._portletResource);
        HashMap<Locale, String> customTitleMap = new HashMap<Locale, String>();
        for (Locale curLocale : LanguageUtil.getAvailableLocales((long)themeDisplay.getSiteGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)curLocale);
            String portletTitle = PortalUtil.getPortletTitle((Portlet)portlet, (ServletContext)servletContext, (Locale)curLocale);
            String portletSetupTitle = this._portletSetup.getValue("portletSetupTitle_" + languageId, portletTitle);
            customTitleMap.put(curLocale, portletSetupTitle);
        }
        return LocalizationUtil.updateLocalization(customTitleMap, (String)"", (String)"customTitle", (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
    }

    public DecimalFormat getDecimalFormat() {
        if (this._decimalFormat != null) {
            return this._decimalFormat;
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        this._decimalFormat = new DecimalFormat("#.##em", decimalFormatSymbols);
        return this._decimalFormat;
    }

    public String getMarginProperty(String position, String property) {
        JSONObject spacingDataJSONObject = this._portletSetupJSONObject.getJSONObject("spacingData");
        if (spacingDataJSONObject == null) {
            return "";
        }
        JSONObject marginSONObject = spacingDataJSONObject.getJSONObject("margin");
        JSONObject marginPositionJSONObject = marginSONObject.getJSONObject(position);
        return marginPositionJSONObject.getString(property);
    }

    public String getPaddingProperty(String position, String property) {
        JSONObject spacingDataJSONObject = this._portletSetupJSONObject.getJSONObject("spacingData");
        if (spacingDataJSONObject == null) {
            return "";
        }
        JSONObject paddingSONObject = spacingDataJSONObject.getJSONObject("padding");
        JSONObject paddingPositionJSONObject = paddingSONObject.getJSONObject(position);
        return paddingPositionJSONObject.getString(property);
    }

    public String getPortletDecoratorId() {
        if (this._portletDecoratorId != null) {
            return this._portletDecoratorId;
        }
        this._portletDecoratorId = this._portletSetup.getValue("portletSetupPortletDecoratorId", this._getDefaultDecoratorId());
        return this._portletDecoratorId;
    }

    public String getPortletResource() {
        return this._portletResource;
    }

    public String getTextDataProperty(String property) {
        JSONObject textDataJSONObject = this._portletSetupJSONObject.getJSONObject("textData");
        if (textDataJSONObject == null) {
            return "";
        }
        return textDataJSONObject.getString(property);
    }

    public boolean hasAccess() throws PortalException {
        if (Validator.isNull((String)this.getPortletResource())) {
            return false;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)this.getPortletResource(), (String)"CONFIGURATION");
    }

    public boolean isBorderSameForAll(String property) {
        JSONObject borderDataJSONObject = this._portletSetupJSONObject.getJSONObject("borderData");
        if (borderDataJSONObject == null) {
            return false;
        }
        JSONObject borderPropertyJSONObject = borderDataJSONObject.getJSONObject(property);
        return borderPropertyJSONObject.getBoolean("sameForAll");
    }

    public boolean isSpacingSameForAll(String property) {
        JSONObject spacingDataJSONObject = this._portletSetupJSONObject.getJSONObject("spacingData");
        if (spacingDataJSONObject == null) {
            return false;
        }
        JSONObject spacingPropertySONObject = spacingDataJSONObject.getJSONObject(property);
        return spacingPropertySONObject.getBoolean("sameForAll");
    }

    public boolean isUseCustomTitle() {
        if (this._useCustomTitle != null) {
            return this._useCustomTitle;
        }
        this._useCustomTitle = GetterUtil.getBoolean((String)this._portletSetup.getValue("portletSetupUseCustomTitle", ""));
        return this._useCustomTitle;
    }

    private String _getDefaultDecoratorId() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Theme theme = themeDisplay.getTheme();
        List portletDecorators = theme.getPortletDecorators();
        Stream portletDecoratorsStream = portletDecorators.stream();
        List filteredPortletDecorators = portletDecoratorsStream.filter(portletDecorator -> portletDecorator.isDefaultPortletDecorator()).collect(Collectors.toList());
        if (ListUtil.isEmpty(filteredPortletDecorators)) {
            return "";
        }
        PortletDecorator defaultPortletDecorator = (PortletDecorator)filteredPortletDecorators.get(0);
        return defaultPortletDecorator.getPortletDecoratorId();
    }
}

