Liferay.Loader.define("portlet-configuration-css-web@4.0.41/js/ColorPickerInput.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './ColorPickerInput.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _ColorPickerInput = _interopRequireDefault(require("./ColorPickerInput.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * ColorPickerInput
   *
   * This class creates an input with a ColorPickerPopover binded to it.
   */
  var ColorPickerInput = /*#__PURE__*/function (_Component) {
    _inherits(ColorPickerInput, _Component);

    function ColorPickerInput() {
      _classCallCheck(this, ColorPickerInput);

      return _possibleConstructorReturn(this, _getPrototypeOf(ColorPickerInput).apply(this, arguments));
    }

    _createClass(ColorPickerInput, [{
      key: "rendered",

      /**
       * @inheritDoc
       */
      value: function rendered() {
        var instance = this;
        AUI().use('aui-color-picker-popover', function (A) {
          instance.colorPickerPopover = new A.ColorPickerPopover({
            color: instance.color,
            constrain: true,
            trigger: '#' + instance.id,
            zIndex: Liferay.zIndex.POPOVER
          });
          instance.colorPickerPopover.render(instance.element);
          instance.colorPickerPopover.after('select', instance.setColor_, instance);
        });
      }
      /**
       * Sets the selected color
       *
       * @param  {Event} event
       */

    }, {
      key: "setColor_",
      value: function setColor_(event) {
        this.color = event.color;
      }
    }]);

    return ColorPickerInput;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @type {!Object}
   * @static
   */

  ColorPickerInput.STATE = {
    /**
     * Current selected color
     * @type {String}
     */
    color: {
      validator: _metal["default"].isString
    },

    /**
     * Input disabled state
     * @type {Boolean}
     */
    disabled: {
      validator: _metal["default"].isBoolean,
      value: false
    },

    /**
     * Id for the input
     * @type {String}
     */
    id: {
      validator: _metal["default"].isString
    },

    /**
     * Input css classes
     * @type {String}
     */
    inputClasses: {
      validator: _metal["default"].isString
    },

    /**
     * Label for the input
     * @type {String}
     */
    label: {
      validator: _metal["default"].isString
    },

    /**
     * Name for the input
     * @type {String}
     */
    name: {
      validator: _metal["default"].isString
    }
  };

  _metalSoy["default"].register(ColorPickerInput, _ColorPickerInput["default"]);

  var _default = ColorPickerInput;
  exports["default"] = _default;
  //# sourceMappingURL=ColorPickerInput.es.js.map
});
//# sourceMappingURL=ColorPickerInput.es.js.map