Liferay.Loader.define("portlet-configuration-css-web@3.0.5/js/ToggleDisableInputs.es", ['exports', 'metal-component/src/all/component', 'metal/src/metal', 'metal-soy/src/Soy', './ToggleDisableInputs.soy'], function (exports, _component, _metal, _Soy, _ToggleDisableInputs) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _component2 = _interopRequireDefault(_component);

	var _metal2 = _interopRequireDefault(_metal);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _ToggleDisableInputs2 = _interopRequireDefault(_ToggleDisableInputs);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var ToggleDisableInputs = function (_Component) {
		_inherits(ToggleDisableInputs, _Component);

		function ToggleDisableInputs() {
			_classCallCheck(this, ToggleDisableInputs);

			return _possibleConstructorReturn(this, (ToggleDisableInputs.__proto__ || Object.getPrototypeOf(ToggleDisableInputs)).apply(this, arguments));
		}

		_createClass(ToggleDisableInputs, [{
			key: 'toggleSwitch',
			value: function toggleSwitch() {
				this.checked = !this.checked;

				this.disableInputs_();
			}
		}, {
			key: 'disableInputs_',
			value: function disableInputs_() {
				var checked = this.checked,
				    disableOnChecked = this.disableOnChecked,
				    inputSelector = this.inputSelector;


				var inputs = document.querySelectorAll(inputSelector);

				for (var i = 0; i < inputs.length; i++) {
					var input = inputs[i];

					input.disabled = disableOnChecked ? checked : !checked;
				}
			}
		}]);

		return ToggleDisableInputs;
	}(_component2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	ToggleDisableInputs.STATE = {

		/**
   * Switch state
   * @type {Boolean}
   */

		checked: {
			validator: _metal2.default.isBoolean,
			value: false
		},

		/**
   * Flag to specify the logic for disabling inputs based on switch state
   * @type {Boolean}
   */

		disableOnChecked: {
			validator: _metal2.default.isBoolean,
			value: true
		},

		/**
   * CSS Selector for the inputs to enable/disable
   * @type {String}
   */

		inputSelector: {
			validator: _metal2.default.isString
		},

		/**
   * Label of the switch
   * @type {String}
   */

		label: {
			validator: _metal2.default.isString
		}
	};

	_Soy2.default.register(ToggleDisableInputs, _ToggleDisableInputs2.default);

	exports.default = ToggleDisableInputs;
});
//# sourceMappingURL=ToggleDisableInputs.es.js.map
