Liferay.Loader.define("portlet-configuration-css-web@3.0.13/js/ColorPickerInput.es", ['exports', 'metal-component/src/all/component', 'metal/src/metal', 'metal-soy/src/Soy', './ColorPickerInput.soy'], function (exports, _component, _metal, _Soy, _ColorPickerInput) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _component2 = _interopRequireDefault(_component);

	var _metal2 = _interopRequireDefault(_metal);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _ColorPickerInput2 = _interopRequireDefault(_ColorPickerInput);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var ColorPickerInput = function (_Component) {
		_inherits(ColorPickerInput, _Component);

		function ColorPickerInput() {
			_classCallCheck(this, ColorPickerInput);

			return _possibleConstructorReturn(this, (ColorPickerInput.__proto__ || Object.getPrototypeOf(ColorPickerInput)).apply(this, arguments));
		}

		_createClass(ColorPickerInput, [{
			key: 'rendered',
			value: function rendered() {
				var instance = this;

				AUI().use('aui-color-picker-popover', function (A) {
					instance.colorPickerPopover = new A.ColorPickerPopover({
						color: instance.color,
						constrain: true,
						trigger: '#' + instance.id,
						zIndex: Liferay.zIndex.POPOVER
					});

					instance.colorPickerPopover.render(instance.element);
					instance.colorPickerPopover.after('select', instance.setColor_, instance);
				});
			}
		}, {
			key: 'setColor_',
			value: function setColor_(event) {
				this.color = event.color;
			}
		}]);

		return ColorPickerInput;
	}(_component2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	ColorPickerInput.STATE = {

		/**
   * Current selected color
   * @type {String}
   */

		color: {
			validator: _metal2.default.isString
		},

		/**
   * Input disabled state
   * @type {Boolean}
   */

		disabled: {
			validator: _metal2.default.isBoolean,
			value: false
		},

		/**
   * Id for the input
   * @type {String}
   */

		id: {
			validator: _metal2.default.isString
		},

		/**
   * Input css classes
   * @type {String}
   */

		inputClasses: {
			validator: _metal2.default.isString
		},

		/**
   * Label for the input
   * @type {String}
   */

		label: {
			validator: _metal2.default.isString
		},

		/**
   * Name for the input
   * @type {String}
   */

		name: {
			validator: _metal2.default.isString
		}
	};

	_Soy2.default.register(ColorPickerInput, _ColorPickerInput2.default);

	exports.default = ColorPickerInput;
});
//# sourceMappingURL=ColorPickerInput.es.js.map
