/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.portlet.tab;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.workflow.portlet.tab.BaseWorkflowPortletTab;
import com.liferay.portal.workflow.portlet.tab.WorkflowPortletTab;
import com.liferay.portal.workflow.web.internal.configuration.WorkflowInstanceWebConfiguration;
import com.liferay.portal.workflow.web.internal.request.prepocessor.WorkflowPreprocessorHelper;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.workflow.web.internal.configuration.WorkflowInstanceWebConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"portal.workflow.tabs.name=submissions"}, service={WorkflowPortletTab.class})
public class WorkflowInstancePortletTab
extends BaseWorkflowPortletTab {
    protected volatile WorkflowInstanceWebConfiguration workflowInstanceWebConfiguration;
    @Reference
    protected WorkflowPreprocessorHelper workflowPreprocessorHelper;
    private static final Log _log = LogFactoryUtil.getLog(WorkflowInstancePortletTab.class);

    public String getName() {
        return "submissions";
    }

    public String getSearchJspPath() {
        return "/instance/workflow_instance_search.jsp";
    }

    public void prepareDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        renderRequest.setAttribute(WorkflowInstanceWebConfiguration.class.getName(), (Object)this.workflowInstanceWebConfiguration);
    }

    public void prepareProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) {
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
        if (StringUtil.equalsIgnoreCase((String)actionName, (String)"invokeTaglibDiscussion")) {
            this.workflowPreprocessorHelper.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    public void prepareRender(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            this.setWorkflowInstanceRenderRequestAttribute(renderRequest);
        }
        catch (Exception e) {
            if (this.workflowPreprocessorHelper.isSessionErrorException(e)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e, (Throwable)e);
                }
                this.workflowPreprocessorHelper.hideDefaultErrorMessage((PortletRequest)renderRequest);
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
            }
            throw new PortletException((Throwable)e);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this.workflowInstanceWebConfiguration = (WorkflowInstanceWebConfiguration)ConfigurableUtil.createConfigurable(WorkflowInstanceWebConfiguration.class, properties);
    }

    protected String getJspPath() {
        return "/instance/view.jsp";
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.portal.workflow.web)", unbind="-")
    protected void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected void setWorkflowInstanceRenderRequestAttribute(RenderRequest renderRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long workflowInstanceId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"workflowInstanceId");
        WorkflowInstance workflowInstance = null;
        if (workflowInstanceId != 0L) {
            workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)themeDisplay.getCompanyId(), (long)workflowInstanceId);
        }
        renderRequest.setAttribute("WORKFLOW_INSTANCE", workflowInstance);
    }
}

