/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.portlet.tab;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManagerUtil;
import com.liferay.portal.workflow.configuration.WorkflowDefinitionConfiguration;
import com.liferay.portal.workflow.portlet.tab.BaseWorkflowPortletTab;
import com.liferay.portal.workflow.portlet.tab.WorkflowPortletTab;
import com.liferay.portal.workflow.web.internal.display.context.WorkflowDefinitionDisplayContext;
import com.liferay.portal.workflow.web.internal.request.prepocessor.WorkflowPreprocessorHelper;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.workflow.configuration.WorkflowDefinitionConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"portal.workflow.tabs.name=workflows"}, service={WorkflowPortletTab.class})
public class WorkflowDefinitionPortletTab
extends BaseWorkflowPortletTab {
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected WorkflowPreprocessorHelper workflowPreprocessorHelper;
    private boolean _companyAdministratorCanPublish;

    public String getName() {
        return "workflows";
    }

    public String getSearchJspPath() {
        return "/definition/workflow_definition_search.jsp";
    }

    public void prepareRender(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            String path = this.workflowPreprocessorHelper.getPath((PortletRequest)renderRequest, (PortletResponse)renderResponse);
            WorkflowDefinitionDisplayContext displayContext = new WorkflowDefinitionDisplayContext(renderRequest, ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)"com.liferay.portal.workflow.web"), this.userLocalService);
            displayContext.setCompanyAdministratorCanPublish(this._companyAdministratorCanPublish);
            renderRequest.setAttribute("WORKFLOW_DEFINITION_DISPLAY_CONTEXT", (Object)displayContext);
            if (Objects.equals(path, "/definition/edit_workflow_definition.jsp") || Objects.equals(path, "/definition/view_workflow_definition.jsp")) {
                this.setWorkflowDefinitionRenderRequestAttribute(renderRequest);
            }
        }
        catch (Exception e) {
            if (this.workflowPreprocessorHelper.isSessionErrorException(e)) {
                this.workflowPreprocessorHelper.hideDefaultErrorMessage((PortletRequest)renderRequest);
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
            }
            throw new PortletException((Throwable)e);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        WorkflowDefinitionConfiguration workflowDefinitionConfiguration = (WorkflowDefinitionConfiguration)ConfigurableUtil.createConfigurable(WorkflowDefinitionConfiguration.class, properties);
        this._companyAdministratorCanPublish = workflowDefinitionConfiguration.companyAdministratorCanPublish();
    }

    protected String getJspPath() {
        return "/definition/view.jsp";
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.portal.workflow.web)", unbind="-")
    protected void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected void setWorkflowDefinitionRenderRequestAttribute(RenderRequest renderRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String name = ParamUtil.getString((PortletRequest)renderRequest, (String)"name");
        if (Validator.isNull((String)name)) {
            return;
        }
        int version = ParamUtil.getInteger((PortletRequest)renderRequest, (String)"version");
        WorkflowDefinition workflowDefinition = WorkflowDefinitionManagerUtil.getWorkflowDefinition((long)themeDisplay.getCompanyId(), (String)name, (int)version);
        renderRequest.setAttribute("WORKFLOW_DEFINITION", (Object)workflowDefinition);
    }
}

